/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.ui.icon.ArrowIcon;
import ding.view.DGraphView;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ArrowShape {
    NONE("No Arrow", "NONE", 0, new int[]{0}, new String[]{"NO_END"}, true),
    DIAMOND("Diamond", "COLOR_DIAMOND", 9, new int[]{9, 7, 8}, new String[]{"EDGE_COLOR_DIAMOND", "WHITE_DIAMOND", "BLACK_DIAMOND"}, true),
    DELTA("Delta", "COLOR_DELTA", 3, new int[]{3, 1, 2}, new String[]{"EDGE_COLOR_DELTA", "WHITE_DELTA", "BLACK_DELTA"}, true),
    ARROW("Arrow", "COLOR_ARROW", 6, new int[]{6, 4, 5}, new String[]{"EDGE_COLOR_ARROW", "WHITE_ARROW", "BLACK_ARROW"}, true),
    T("T", "COLOR_T", 15, new int[]{15, 13, 14}, new String[]{"EDGE_COLOR_T", "WHITE_T", "BLACK_T"}, true),
    CIRCLE("Circle", "COLOR_CIRCLE", 12, new int[]{12, 10, 11}, new String[]{"EDGE_COLOR_CIRCLE", "WHITE_CIRCLE", "BLACK_CIRCLE"}, true),
    HALF_ARROW_TOP("Half Arrow Top", "HALF_ARROW_TOP", 16, new int[]{16}, new String[]{"HALF_ARROW_TOP"}, false),
    HALF_ARROW_BOTTOM("Half Arrow Bottom", "HALF_ARROW_BOTTOM", 17, new int[]{17}, new String[]{"HALF_ARROW_BOTTOM"}, false);

    private static Map<Integer, Shape> arrowShapes;
    private String shapeName;
    private String ginyShapeName;
    private int ginyType;
    private int[] possibleGinyTypes;
    private String[] possibleGinyNames;
    private boolean renderEdgeWithArrow;

    private ArrowShape(String shapeName, String ginyShapeName, int ginyType, int[] possibleGinyTypes, String[] possibleGinyNames, boolean renderEdgeWithArrow) {
        this.shapeName = shapeName;
        this.ginyShapeName = ginyShapeName;
        this.ginyType = ginyType;
        this.possibleGinyTypes = possibleGinyTypes;
        this.possibleGinyNames = possibleGinyNames;
        this.renderEdgeWithArrow = renderEdgeWithArrow;
    }

    public int getGinyArrow() {
        return this.ginyType;
    }

    public String getGinyName() {
        return this.ginyShapeName;
    }

    public String getName() {
        return this.shapeName;
    }

    public static ArrowShape parseArrowText(String text) {
        try {
            ArrowShape val = ArrowShape.valueOf(text);
            return val;
        }
        catch (IllegalArgumentException e) {
            for (ArrowShape shape : ArrowShape.values()) {
                if (shape.shapeName.equals(text) || shape.ginyShapeName.equals(text)) {
                    return shape;
                }
                for (String possibleName : shape.getPossibleGinyNames()) {
                    if (!possibleName.equals(text)) continue;
                    return shape;
                }
            }
            return NONE;
        }
    }

    public String[] getPossibleGinyNames() {
        return this.possibleGinyNames;
    }

    public int[] getPossibleGinyTypes() {
        return this.possibleGinyTypes;
    }

    public static ArrowShape getArrowShape(int ginyType) {
        for (ArrowShape shape : ArrowShape.values()) {
            if (shape.getGinyArrow() != ginyType) continue;
            return shape;
        }
        for (ArrowShape shape : ArrowShape.values()) {
            for (int possible : shape.getPossibleGinyTypes()) {
                if (possible != ginyType) continue;
                return shape;
            }
        }
        return NONE;
    }

    public Shape getShape() {
        return arrowShapes.get(this.ginyType);
    }

    public boolean renderEdgeWithArrow() {
        return this.renderEdgeWithArrow;
    }

    public static Map<Object, Icon> getIconSet() {
        HashMap<Object, Icon> arrowShapeIcons = new HashMap<Object, Icon>();
        for (ArrowShape arrow : ArrowShape.values()) {
            arrowShapeIcons.put((Object)arrow, new ArrowIcon(arrow, 32));
        }
        return arrowShapeIcons;
    }

    static {
        arrowShapes = DGraphView.getArrowShapes();
    }
}

