/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import ding.view.DGraphView;
import ding.view.DNodeView;
import giny.view.NodeView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedNetworkViewUpdater
implements PropertyChangeListener {
    private static final String NESTED_NETWORK_VS_NAME = "Nested Network Style";
    private final VisualMappingManager vmm = Cytoscape.getVisualMappingManager();
    private boolean ignoreNextEvent = false;

    public NestedNetworkViewUpdater() {
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("NETWORK_VIEW_CREATED") || evt.getPropertyName().equals("NETWORK_VIEW_DESTROYED")) {
            List parents;
            if (this.ignoreNextEvent) {
                this.ignoreNextEvent = false;
                return;
            }
            this.ignoreNextEvent = true;
            boolean created = evt.getPropertyName().equals("NETWORK_VIEW_CREATED");
            CyNetworkView view = (CyNetworkView)evt.getNewValue();
            if (created) {
                this.updateNodeViews(view.getNetwork(), view);
            }
            if ((parents = Cytoscape.getNetworkAttributes().getListAttribute(view.getNetwork().getIdentifier(), "parent_nodes")) == null || parents.isEmpty()) {
                return;
            }
            this.setNestedNetworkViews(parents, created);
        } else if (evt.getPropertyName().equals("NESTED_NETWORK_CREATED")) {
            CyNode parentNode = (CyNode)evt.getOldValue();
            ArrayList<String> parents = new ArrayList<String>();
            parents.add(parentNode.getIdentifier());
            this.setNestedNetworkViews(parents, true);
        } else if (evt.getPropertyName().equals("NESTED_NETWORK_DESTROYED")) {
            CyNode parentNode = (CyNode)evt.getOldValue();
            ArrayList<String> parents = new ArrayList<String>();
            parents.add(parentNode.getIdentifier());
            this.setNestedNetworkViews(parents, false);
        }
    }

    private void setNestedNetworkViews(List<String> parents, boolean created) {
        Collection<CyNetworkView> networkViews = Cytoscape.getNetworkViewMap().values();
        for (CyNetworkView networkView : networkViews) {
            boolean applyStyle = false;
            for (String parentNode : parents) {
                NodeView nodeView;
                CyNode node = Cytoscape.getCyNode(parentNode);
                if (node == null || (nodeView = networkView.getNodeView(node)) == null) continue;
                CyNetwork nestedNetwork = (CyNetwork)nodeView.getNode().getNestedNetwork();
                if (nestedNetwork != null) {
                    CyNetworkView nestedNetworkView = Cytoscape.getNetworkView(nestedNetwork.getIdentifier());
                    if (nestedNetworkView == Cytoscape.getNullNetworkView()) {
                        nestedNetworkView = null;
                    }
                    ((DNodeView)nodeView).setNestedNetworkView(created ? (DGraphView)((Object)nestedNetworkView) : null);
                }
                applyStyle = true;
            }
            if (!applyStyle) continue;
            VisualStyle currentStyle = this.vmm.getVisualStyle();
            if (!currentStyle.equals(networkView.getVisualStyle())) {
                this.vmm.setVisualStyle(networkView.getVisualStyle());
                networkView.redrawGraph(false, true);
                this.vmm.setVisualStyle(currentStyle);
                continue;
            }
            networkView.redrawGraph(false, true);
        }
    }

    private void updateNodeViews(CyNetwork currentNetwork, CyNetworkView currentNetworkView) {
        for (CyNode node : currentNetwork.nodesList()) {
            CyNetworkView nestedNetworkView;
            CyNetwork nestedNetwork = (CyNetwork)node.getNestedNetwork();
            if (nestedNetwork == null || (nestedNetworkView = Cytoscape.getNetworkView(nestedNetwork.getIdentifier())).equals(Cytoscape.getNullNetworkView())) continue;
            NodeView nodeView = currentNetworkView.getNodeView(node);
            ((DNodeView)nodeView).setNestedNetworkView((DGraphView)((Object)nestedNetworkView));
        }
    }
}

