/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.ColorUtil;
import java.awt.Color;
import junit.framework.TestCase;

public class ColorUtilTest
extends TestCase {
    public void testParseColorText() {
        String black = "black";
        String darkGray = "darkgray";
        String darkGrayRGB = "169, 169, 169";
        Color darkGrayColor = ColorUtil.parseColorText(darkGray);
        Color darkGrayColor2 = ColorUtil.parseColorText(darkGrayRGB);
        String seaShell = "  SeaShell    ";
        Color seaShellColor = Color.decode("#FFF5EE");
        String mediumTurquoise = "mediumturquoise";
        Color mediumTurquoiseColor = ColorUtil.parseColorText("72, 209,204 ");
        String nonsense = "dkajshfls/>-d13opr[wepq-83=";
        ColorUtilTest.assertEquals(Color.black, ColorUtil.parseColorText(black));
        ColorUtilTest.assertEquals(Color.decode("#A9A9A9"), darkGrayColor);
        ColorUtilTest.assertEquals(darkGrayColor, darkGrayColor2);
        ColorUtilTest.assertEquals(seaShellColor, ColorUtil.parseColorText(seaShell));
        ColorUtilTest.assertEquals(mediumTurquoiseColor, ColorUtil.parseColorText(mediumTurquoise));
        ColorUtilTest.assertNull(ColorUtil.parseColorText(nonsense));
    }

    public void testGetColorAsText() {
        ColorUtilTest.assertNotNull(ColorUtil.getColorAsText(Color.white));
        ColorUtilTest.assertEquals("0,0,0", ColorUtil.getColorAsText(Color.black));
    }
}

