/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.Cytoscape;
import cytoscape.util.URLUtil;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ColorUtil {
    private static final int COLOR_RANGE_MAX = 255;
    private static final Map<String, String> COLOR_MAP = new HashMap<String, String>();
    private static final String COLOR_CODE_RESOURCE = "resources/cross_browser_color_code.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void buildColorCodeTable(URL resourceURL) {
        BufferedReader bufRd = null;
        try {
            try {
                String line;
                bufRd = new BufferedReader(new InputStreamReader(URLUtil.getBasicInputStream(resourceURL)));
                while ((line = bufRd.readLine()) != null) {
                    String[] parts = line.split("\\t");
                    COLOR_MAP.put(parts[0].trim().toUpperCase(), parts[1].trim());
                }
                Object var5_5 = null;
                if (bufRd == null) return;
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var5_6 = null;
                if (bufRd == null) return;
                try {
                    try {
                        bufRd.close();
                        return;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    bufRd = null;
                    throw throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (bufRd == null) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_16 = null;
                bufRd = null;
                throw throwable2;
            }
            try {}
            catch (IOException e2) {
                e2.printStackTrace();
                Object var8_15 = null;
                bufRd = null;
                throw throwable;
            }
            bufRd.close();
            Object var8_14 = null;
            bufRd = null;
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var8_10 = null;
            bufRd = null;
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        bufRd.close();
    }

    public static Color parseColorText(String colorAsText) {
        if (colorAsText == null) {
            return null;
        }
        String trimed = colorAsText.trim();
        String[] parts = trimed.split(",");
        if (parts.length == 1) {
            try {
                String upper = trimed.toUpperCase();
                if (COLOR_MAP.containsKey(upper)) {
                    return Color.decode(COLOR_MAP.get(upper));
                }
                return Color.decode(trimed);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (parts.length != 3) {
            return null;
        }
        String red = parts[0].trim();
        String green = parts[1].trim();
        String blue = parts[2].trim();
        try {
            if (red.contains(".") || green.contains(".") || blue.contains(".")) {
                float r = Float.parseFloat(red);
                float g = Float.parseFloat(green);
                float b = Float.parseFloat(blue);
                return new Color(r, g, b);
            }
            int r = Integer.parseInt(red);
            int g = Integer.parseInt(green);
            int b = Integer.parseInt(blue);
            return new Color(r, g, b);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getColorAsText(Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public static Color getComplementaryColor(Color color1) {
        Color complement = new Color(255 - color1.getRed(), 255 - color1.getGreen(), 255 - color1.getBlue());
        float[] hsb = Color.RGBtoHSB(color1.getRed(), color1.getGreen(), color1.getBlue(), null);
        float[] cHSB = Color.RGBtoHSB(complement.getRed(), complement.getGreen(), complement.getBlue(), null);
        if (hsb[2] > 0.7f) {
            return Color.getHSBColor(cHSB[0], 1.0f - hsb[1], 0.0f);
        }
        return Color.getHSBColor(cHSB[0], 1.0f - hsb[1], 1.0f);
    }

    static {
        ColorUtil.buildColorCodeTable(Cytoscape.class.getResource(COLOR_CODE_RESOURCE));
    }
}

