/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.render.stateful;

import cytoscape.render.stateful.MeasuredLine;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MeasuredLineCreator {
    private double maxLineWidth;
    private double totalHeight;
    private final double labelWidth;
    private final String rawLine;
    private final String[] rawLines;
    private final FontRenderContext frc;
    private final Font font;
    private final double fontScaleFactor;
    private final boolean textAsShape;
    private final List<MeasuredLine> measuredLines;

    public MeasuredLineCreator(String rawLine, Font font, FontRenderContext frc, double fontScaleFactor, boolean textAsShape, double labelWidth) {
        this.rawLine = rawLine;
        this.font = font;
        this.frc = frc;
        this.fontScaleFactor = fontScaleFactor;
        this.textAsShape = textAsShape;
        this.labelWidth = labelWidth;
        this.rawLines = rawLine.split("\n");
        this.measuredLines = new ArrayList<MeasuredLine>();
        this.calculateRawBounds();
        this.createMeasuredLines();
    }

    private void calculateRawBounds() {
        this.maxLineWidth = 0.0;
        this.totalHeight = 0.0;
        for (String line : this.rawLines) {
            Rectangle2D bounds = this.calcBounds(line);
            this.updateBounds(bounds.getWidth() * this.fontScaleFactor, bounds.getHeight() * this.fontScaleFactor);
        }
    }

    private void updateBounds(double newWidth, double newHeight) {
        this.maxLineWidth = Math.max(this.maxLineWidth, newWidth);
        this.totalHeight += newHeight;
    }

    private Rectangle2D calcBounds(String s) {
        Rectangle2D bounds;
        if (this.textAsShape) {
            char[] charBuff = s.toCharArray();
            GlyphVector glyphV = this.font.layoutGlyphVector(this.frc, charBuff, 0, charBuff.length, 4);
            bounds = glyphV.getLogicalBounds();
        } else {
            bounds = this.font.getStringBounds(s, this.frc);
        }
        return bounds;
    }

    private void createMeasuredLines() {
        if (this.rawLines.length == 1 && this.labelWidth > this.maxLineWidth) {
            this.measuredLines.add(new MeasuredLine(this.rawLines[0], this.maxLineWidth, this.totalHeight));
            return;
        }
        this.totalHeight = 0.0;
        this.maxLineWidth = 0.0;
        for (String line : this.rawLines) {
            String[] words;
            double currentWidth = 0.0;
            double wordWidth = 0.0;
            double wordHeight = 0.0;
            StringBuilder currentLine = new StringBuilder();
            for (String w : words = line.split(" ")) {
                String word = w + " ";
                Rectangle2D bounds = this.calcBounds(word);
                wordWidth = bounds.getWidth() * this.fontScaleFactor;
                wordHeight = bounds.getHeight() * this.fontScaleFactor;
                if (currentWidth + wordWidth >= this.labelWidth) {
                    if (currentWidth > 0.0) {
                        this.measuredLines.add(new MeasuredLine(currentLine.toString(), currentWidth, wordHeight));
                        this.updateBounds(currentWidth, wordHeight);
                        currentLine.delete(0, currentLine.length());
                    }
                    if (wordWidth >= this.labelWidth) {
                        this.measuredLines.add(new MeasuredLine(word, wordWidth, wordHeight));
                        this.updateBounds(wordWidth, wordHeight);
                        currentWidth = 0.0;
                        continue;
                    }
                    currentLine.append(word);
                    currentWidth = wordWidth;
                    continue;
                }
                currentLine.append(word);
                currentWidth += wordWidth;
            }
            if (!(currentWidth > 0.0)) continue;
            this.measuredLines.add(new MeasuredLine(currentLine.toString(), currentWidth, wordHeight));
            this.updateBounds(currentWidth, wordHeight);
        }
    }

    public double getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public double getTotalHeight() {
        return this.totalHeight;
    }

    public List<MeasuredLine> getMeasuredLines() {
        return this.measuredLines;
    }
}

