/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.render.immed.arrow;

import cytoscape.render.immed.arrow.AbstractArrow;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class DiscArrow
extends AbstractArrow {
    private final GeneralPath capGP;
    private final Arc2D.Double capA;
    private double currentRatio;

    public DiscArrow() {
        super((byte)-4, 1.0);
        Ellipse2D.Double arrowE = new Ellipse2D.Double();
        arrowE.setFrame(-1.0, -0.5, 1.0, 1.0);
        this.arrow = arrowE;
        this.capGP = new GeneralPath();
        this.capA = new Arc2D.Double();
        this.currentRatio = Double.NaN;
    }

    public synchronized Shape getCapShape(double ratio) {
        if (this.currentRatio != Double.NaN && ratio == this.currentRatio) {
            return this.capGP;
        }
        this.currentRatio = ratio;
        double theta = Math.toDegrees(Math.asin(1.0 / ratio));
        this.capA.setArc(0.0, ratio / -2.0, ratio, ratio, 180.0 - theta, theta * 2.0, 0);
        this.capGP.reset();
        this.capGP.append(this.capA, false);
        this.capGP.lineTo(0.0f, 0.5f);
        this.capGP.lineTo(0.0f, -0.5f);
        this.capGP.closePath();
        return this.capGP;
    }
}

