/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.render.immed;

import cytoscape.render.immed.EdgeAnchors;
import cytoscape.render.immed.arrow.Arrow;
import cytoscape.render.immed.arrow.ArrowheadArrow;
import cytoscape.render.immed.arrow.DeltaArrow;
import cytoscape.render.immed.arrow.DiamondArrow;
import cytoscape.render.immed.arrow.DiscArrow;
import cytoscape.render.immed.arrow.HalfBottomArrow;
import cytoscape.render.immed.arrow.HalfTopArrow;
import cytoscape.render.immed.arrow.NoArrow;
import cytoscape.render.immed.arrow.TeeArrow;
import cytoscape.render.immed.nodeshape.DiamondNodeShape;
import cytoscape.render.immed.nodeshape.EllipseNodeShape;
import cytoscape.render.immed.nodeshape.HexagonNodeShape;
import cytoscape.render.immed.nodeshape.LegacyCustomNodeShape;
import cytoscape.render.immed.nodeshape.NodeShape;
import cytoscape.render.immed.nodeshape.OctagonNodeShape;
import cytoscape.render.immed.nodeshape.ParallelogramNodeShape;
import cytoscape.render.immed.nodeshape.RectangleNodeShape;
import cytoscape.render.immed.nodeshape.RoundedRectangleNodeShape;
import cytoscape.render.immed.nodeshape.TriangleNodeShape;
import cytoscape.render.immed.nodeshape.VeeNodeShape;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphGraphics {
    public static final byte SHAPE_RECTANGLE = 0;
    public static final byte SHAPE_DIAMOND = 1;
    public static final byte SHAPE_ELLIPSE = 2;
    public static final byte SHAPE_HEXAGON = 3;
    public static final byte SHAPE_OCTAGON = 4;
    public static final byte SHAPE_PARALLELOGRAM = 5;
    public static final byte SHAPE_ROUNDED_RECTANGLE = 6;
    public static final byte SHAPE_TRIANGLE = 7;
    public static final byte SHAPE_VEE = 8;
    static final byte s_last_shape = 8;
    private static final Map<Byte, NodeShape> nodeShapes;
    public static final int CUSTOM_SHAPE_MAX_VERTICES = 100;
    public static final byte ARROW_NONE = -1;
    public static final byte ARROW_DELTA = -2;
    public static final byte ARROW_DIAMOND = -3;
    public static final byte ARROW_DISC = -4;
    public static final byte ARROW_TEE = -5;
    public static final byte ARROW_HALF_TOP = -6;
    public static final byte ARROW_HALF_BOTTOM = -7;
    public static final byte ARROW_ARROWHEAD = -8;
    private static final Map<Byte, Arrow> arrows;
    public static final int MAX_EDGE_ANCHORS = 64;
    private static final double CURVE_ELLIPTICAL;
    private static final GraphGraphics dummyGraphics;
    private static final Map<Float, Stroke> borderStrokes;
    private static final float DEF_SHAPE_SIZE = 32.0f;
    public final Image image;
    private final boolean m_debug;
    private final AffineTransform m_currXform = new AffineTransform();
    private final AffineTransform m_currNativeXform = new AffineTransform();
    private final AffineTransform m_xformUtil = new AffineTransform();
    private final Arc2D.Double m_arc2d = new Arc2D.Double();
    private final Ellipse2D.Double m_ellp2d = new Ellipse2D.Double();
    private final GeneralPath m_path2d = new GeneralPath();
    private final GeneralPath m_path2dPrime = new GeneralPath();
    private final Line2D.Double m_line2d = new Line2D.Double();
    private final double[] m_ptsBuff = new double[4];
    final EdgeAnchors m_noAnchors = new EdgeAnchors(){

        public final int numAnchors() {
            return 0;
        }

        public final void getAnchor(int inx, float[] arr, int off) {
        }
    };
    private final double[] m_edgePtsBuff = new double[390];
    private int m_edgePtsCount;
    private Graphics2D m_g2d;
    private Graphics2D m_gMinimal;
    private boolean m_cleared;
    private byte m_lastCustomShapeType = (byte)8;
    private final float[] m_floatBuff = new float[2];
    private char[] m_charBuff = new char[20];
    private final FontRenderContext m_fontRenderContextFull = new FontRenderContext(null, true, true);

    public GraphGraphics(Image image, boolean debug) {
        this.image = image;
        this.m_debug = debug;
        this.m_path2dPrime.setWindingRule(0);
        this.m_cleared = false;
    }

    public final void clear(Paint bgPaint, double xCenter, double yCenter, double scaleFactor) {
        if (this.m_debug) {
            this.checkDispatchThread();
            if (!(scaleFactor > 0.0)) {
                throw new IllegalArgumentException("scaleFactor is not positive");
            }
        }
        if (this.m_gMinimal != null) {
            this.m_gMinimal.dispose();
            this.m_gMinimal = null;
        }
        if (this.m_g2d != null) {
            this.m_g2d.dispose();
        }
        this.m_g2d = (Graphics2D)this.image.getGraphics();
        Composite origComposite = this.m_g2d.getComposite();
        this.m_g2d.setComposite(AlphaComposite.getInstance(2));
        this.m_g2d.setPaint(bgPaint);
        this.m_g2d.fillRect(0, 0, this.image.getWidth(null), this.image.getHeight(null));
        this.m_g2d.setComposite(origComposite);
        this.m_g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.m_g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.m_g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        this.m_g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        this.m_g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        this.m_g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.m_g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.m_g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.m_g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.m_g2d.setStroke(new BasicStroke(0.0f, 1, 1, 10.0f));
        this.m_currXform.setToTranslation(0.5 * (double)this.image.getWidth(null), 0.5 * (double)this.image.getHeight(null));
        this.m_currXform.scale(scaleFactor, scaleFactor);
        this.m_currXform.translate(-xCenter, -yCenter);
        this.m_g2d.transform(this.m_currXform);
        this.m_currNativeXform.setTransform(this.m_g2d.getTransform());
        this.m_cleared = true;
    }

    public final void xformImageToNodeCoords(double[] coords) {
        if (this.m_debug) {
            this.checkDispatchThread();
            this.checkCleared();
        }
        try {
            this.m_currXform.inverseTransform(coords, 0, coords, 0, 1);
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException("noninvertible matrix - cannot happen");
        }
    }

    public final AffineTransform getTransform() {
        return this.m_currXform;
    }

    public final void drawNodeLow(float xMin, float yMin, float xMax, float yMax, Color fillColor) {
        if (this.m_debug) {
            this.checkDispatchThread();
            this.checkCleared();
            this.checkOrder(xMin, xMax, "x");
            this.checkOrder(yMin, yMax, "y");
            if (fillColor.getAlpha() != 255) {
                throw new IllegalArgumentException("fillColor is not opaque");
            }
        }
        if (this.m_gMinimal == null) {
            this.makeMinimalGraphics();
        }
        this.m_ptsBuff[0] = xMin;
        this.m_ptsBuff[1] = yMin;
        this.m_ptsBuff[2] = xMax;
        this.m_ptsBuff[3] = yMax;
        this.m_currXform.transform(this.m_ptsBuff, 0, this.m_ptsBuff, 0, 2);
        int xNot = (int)this.m_ptsBuff[0];
        int yNot = (int)this.m_ptsBuff[1];
        int xOne = (int)this.m_ptsBuff[2];
        int yOne = (int)this.m_ptsBuff[3];
        this.m_gMinimal.setColor(fillColor);
        this.m_gMinimal.fillRect(xNot, yNot, Math.max(1, xOne - xNot), Math.max(1, yOne - yNot));
    }

    private final void makeMinimalGraphics() {
        this.m_gMinimal = (Graphics2D)this.image.getGraphics();
        this.m_gMinimal.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
    }

    public final void drawNodeFull(byte nodeShape, float xMin, float yMin, float xMax, float yMax, Paint fillPaint, float borderWidth, Paint borderPaint) {
        if (this.m_debug) {
            this.checkDispatchThread();
            this.checkCleared();
            this.checkOrder(xMin, xMax, "x");
            this.checkOrder(yMin, yMax, "y");
            if (!(borderWidth >= 0.0f)) {
                throw new IllegalArgumentException("borderWidth not zero or positive");
            }
            if (!(6.0 * (double)borderWidth <= Math.min((double)xMax - (double)xMin, (double)yMax - (double)yMin))) {
                throw new IllegalArgumentException("borderWidth is not less than the minimum of node width and node height divided by six");
            }
        }
        float off = borderWidth / 2.0f;
        Shape sx = this.getShape(nodeShape, xMin + off, yMin + off, xMax - off, yMax - off);
        if (borderWidth > 0.0f) {
            this.m_g2d.setPaint(borderPaint);
            this.m_g2d.setStroke(this.getStroke(borderWidth));
            this.m_g2d.draw(sx);
        }
        this.m_g2d.setPaint(fillPaint);
        this.m_g2d.fill(sx);
    }

    public final void getNodeShape(byte nodeShape, float xMin, float yMin, float xMax, float yMax, GeneralPath path) {
        if (this.m_debug) {
            this.checkDispatchThread();
            this.checkOrder(xMin, xMax, "x");
            this.checkOrder(yMin, yMax, "y");
        }
        path.reset();
        path.append(this.getShape(nodeShape, xMin, yMin, xMax, yMax), false);
    }

    public final byte defineCustomNodeShape(float[] coords, int offset, int vertexCount) {
        if (this.m_debug) {
            this.checkDispatchThread();
        }
        if (vertexCount > 100) {
            throw new IllegalArgumentException("too many vertices (greater than 100)");
        }
        double[] polyCoords = new double[vertexCount * 2];
        for (int i = 0; i < polyCoords.length; ++i) {
            polyCoords[i] = coords[offset + i];
        }
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < polyCoords.length) {
            xMin = Math.min(xMin, (double)coords[i]);
            xMax = Math.max(xMax, (double)coords[i++]);
            yMin = Math.min(yMin, (double)coords[i]);
            yMax = Math.max(yMax, (double)coords[i++]);
        }
        double xDist = xMax - xMin;
        if (xDist == 0.0) {
            throw new IllegalArgumentException("polygon does not move in the X direction");
        }
        double yDist = yMax - yMin;
        if (yDist == 0.0) {
            throw new IllegalArgumentException("polygon does not move in the Y direction");
        }
        double xMid = (xMin + xMax) / 2.0;
        double yMid = (yMin + yMax) / 2.0;
        int i2 = 0;
        while (i2 < polyCoords.length) {
            double foo = (polyCoords[i2] - xMid) / xDist;
            polyCoords[i2++] = Math.min(Math.max(-0.5, foo), 0.5);
            foo = (polyCoords[i2] - yMid) / yDist;
            polyCoords[i2++] = Math.min(Math.max(-0.5, foo), 0.5);
        }
        int yInterceptsCenter = 0;
        for (int i3 = 0; i3 < vertexCount; ++i3) {
            double x0 = polyCoords[i3 * 2];
            double y0 = polyCoords[i3 * 2 + 1];
            double x1 = polyCoords[(i3 * 2 + 2) % (vertexCount * 2)];
            double y1 = polyCoords[(i3 * 2 + 3) % (vertexCount * 2)];
            double x2 = polyCoords[(i3 * 2 + 4) % (vertexCount * 2)];
            double y2 = polyCoords[(i3 * 2 + 5) % (vertexCount * 2)];
            double distP0P1 = Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
            if ((float)distP0P1 == 0.0f) {
                throw new IllegalArgumentException("a line segment has distance [too close to] zero");
            }
            double distP2fromP0P1 = ((y0 - y1) * x2 + (x1 - x0) * y2 + x0 * y1 - x1 * y0) / distP0P1;
            if ((float)distP2fromP0P1 == 0.0f) {
                throw new IllegalArgumentException("either a line segment has distance [too close to] zero or two consecutive line segments are [too close to] parallel");
            }
            double distCenterFromP0P1 = (x0 * y1 - x1 * y0) / distP0P1;
            if (!((float)distCenterFromP0P1 > 0.0f)) {
                throw new IllegalArgumentException("polygon is going counter-clockwise or is not star-shaped with respect to center");
            }
            if (!(Math.min(y0, y1) < 0.0) || !(Math.max(y0, y1) >= 0.0)) continue;
            ++yInterceptsCenter;
        }
        if (yInterceptsCenter != 2) {
            throw new IllegalArgumentException("the polygon self-intersects (we know this because the winding number of the center is not one)");
        }
        byte nextCustomShapeType = (byte)(this.m_lastCustomShapeType + 1);
        if (nextCustomShapeType < 0) {
            throw new IllegalStateException("too many custom node shapes are already defined");
        }
        this.m_lastCustomShapeType = (byte)(this.m_lastCustomShapeType + 1);
        nodeShapes.put(nextCustomShapeType, new LegacyCustomNodeShape(polyCoords, nextCustomShapeType));
        return nextCustomShapeType;
    }

    public final boolean customNodeShapeExists(byte shape) {
        if (this.m_debug) {
            this.checkDispatchThread();
        }
        return shape > 8 && shape <= this.m_lastCustomShapeType;
    }

    public final byte[] getCustomNodeShapes() {
        if (this.m_debug) {
            this.checkDispatchThread();
        }
        byte[] returnThis = new byte[this.m_lastCustomShapeType - 8];
        for (int i = 0; i < returnThis.length; ++i) {
            returnThis[i] = (byte)(9 + i);
        }
        return returnThis;
    }

    public final float[] getCustomNodeShape(byte customShape) {
        if (this.m_debug) {
            this.checkDispatchThread();
        }
        if (!this.customNodeShapeExists(customShape)) {
            return null;
        }
        LegacyCustomNodeShape ns = (LegacyCustomNodeShape)nodeShapes.get(customShape);
        return ns.getCoords();
    }

    public final void importCustomNodeShapes(GraphGraphics grafx) {
        if (this.m_debug) {
            this.checkDispatchThread();
        }
        if (this.m_lastCustomShapeType != 8) {
            throw new IllegalStateException("a custom node shape is already defined in this GraphGraphics");
        }
        for (Map.Entry<Byte, NodeShape> entry : nodeShapes.entrySet()) {
            nodeShapes.put(entry.getKey(), entry.getValue());
            this.m_lastCustomShapeType = (byte)(this.m_lastCustomShapeType + 1);
        }
    }

    private final Shape getShape(byte nodeShape, float xMin, float yMin, float xMax, float yMax) {
        NodeShape ns = nodeShapes.get(nodeShape);
        if (ns != null) {
            return ns.getShape(xMin, yMin, xMax, yMax);
        }
        return null;
    }

    public static Map<Byte, Shape> getNodeShapes() {
        HashMap<Byte, Shape> shapeMap = new HashMap<Byte, Shape>();
        for (NodeShape ns : nodeShapes.values()) {
            Shape shape = ns.getShape(0.0f, 0.0f, 32.0f, 32.0f);
            shapeMap.put(ns.getType(), new GeneralPath(shape));
        }
        return shapeMap;
    }

    public static Map<Byte, Shape> getArrowShapes() {
        HashMap<Byte, Shape> shapeMap = new HashMap<Byte, Shape>();
        for (Arrow a : arrows.values()) {
            shapeMap.put(a.getType(), a.getArrowShape());
        }
        return shapeMap;
    }

    public final void drawEdgeLow(float x0, float y0, float x1, float y1, Color edgeColor) {
        if (this.m_debug) {
            this.checkDispatchThread();
            this.checkCleared();
            if (edgeColor.getAlpha() != 255) {
                throw new IllegalArgumentException("edgeColor is not opaque");
            }
        }
        if (x0 == x1 && y0 == y1) {
            return;
        }
        if (this.m_gMinimal == null) {
            this.makeMinimalGraphics();
        }
        this.m_ptsBuff[0] = x0;
        this.m_ptsBuff[1] = y0;
        this.m_ptsBuff[2] = x1;
        this.m_ptsBuff[3] = y1;
        this.m_currXform.transform(this.m_ptsBuff, 0, this.m_ptsBuff, 0, 2);
        int xNot = (int)this.m_ptsBuff[0];
        int yNot = (int)this.m_ptsBuff[1];
        int xOne = (int)this.m_ptsBuff[2];
        int yOne = (int)this.m_ptsBuff[3];
        this.m_gMinimal.setColor(edgeColor);
        this.m_gMinimal.drawLine(xNot, yNot, xOne, yOne);
    }

    public final void drawEdgeFull(byte arrow0Type, float arrow0Size, Paint arrow0Paint, byte arrow1Type, float arrow1Size, Paint arrow1Paint, float x0, float y0, EdgeAnchors anchors, float x1, float y1, float edgeThickness, Stroke edgeStroke, Paint edgePaint) {
        Shape arrow1;
        Shape arrow0;
        long startTime = System.nanoTime();
        double curveFactor = CURVE_ELLIPTICAL;
        if (anchors == null) {
            anchors = this.m_noAnchors;
        }
        if (this.m_debug) {
            this.edgeFullDebug(arrow0Type, arrow0Size, arrow1Type, arrow1Size, edgeStroke, edgeThickness, anchors);
        }
        if (!this.computeCubicPolyEdgePath(arrow0Type, arrow0Type == -1 ? 0.0f : arrow0Size, arrow1Type, arrow1Type == -1 ? 0.0f : arrow1Size, x0, y0, anchors, x1, y1, curveFactor)) {
            if (this.m_edgePtsCount == 2) {
                this.drawSimpleEdgeFull(arrow0Type, arrow0Size, arrow0Paint, arrow1Type, arrow1Size, arrow1Paint, (float)this.m_edgePtsBuff[0], (float)this.m_edgePtsBuff[1], (float)this.m_edgePtsBuff[2], (float)this.m_edgePtsBuff[3], edgeThickness, edgeStroke, edgePaint);
            }
            return;
        }
        boolean simpleSegment = arrow0Type == -1 && arrow1Type == -1;
        this.m_g2d.setStroke(edgeStroke);
        this.m_path2d.reset();
        this.m_path2d.moveTo((float)this.m_edgePtsBuff[2], (float)this.m_edgePtsBuff[3]);
        int inx = 4;
        int count = (this.m_edgePtsCount - 1) * 6 - 2;
        while (inx < count) {
            this.m_path2d.curveTo((float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++]);
        }
        this.m_g2d.setPaint(edgePaint);
        this.m_g2d.draw(this.m_path2d);
        if (simpleSegment) {
            return;
        }
        double dx0 = this.m_edgePtsBuff[0] - this.m_edgePtsBuff[4];
        double dy0 = this.m_edgePtsBuff[1] - this.m_edgePtsBuff[5];
        double len0 = Math.sqrt(dx0 * dx0 + dy0 * dy0);
        double cosTheta0 = dx0 / len0;
        double sinTheta0 = dy0 / len0;
        double dx1 = this.m_edgePtsBuff[(this.m_edgePtsCount - 1) * 6 - 2] - this.m_edgePtsBuff[(this.m_edgePtsCount - 1) * 6 - 6];
        double dy1 = this.m_edgePtsBuff[(this.m_edgePtsCount - 1) * 6 - 1] - this.m_edgePtsBuff[(this.m_edgePtsCount - 1) * 6 - 5];
        double len1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        double cosTheta1 = dx1 / len1;
        double sinTheta1 = dy1 / len1;
        if (edgeStroke instanceof BasicStroke) {
            Shape arrow1Cap;
            Shape arrow0Cap = this.computeUntransformedArrowCap(arrow0Type, (double)arrow0Size / (double)edgeThickness);
            if (arrow0Cap != null) {
                this.m_xformUtil.setTransform(cosTheta0, sinTheta0, -sinTheta0, cosTheta0, this.m_edgePtsBuff[2], this.m_edgePtsBuff[3]);
                this.m_g2d.transform(this.m_xformUtil);
                this.m_g2d.scale(edgeThickness, edgeThickness);
                this.m_g2d.fill(arrow0Cap);
                this.m_g2d.setTransform(this.m_currNativeXform);
            }
            if ((arrow1Cap = this.computeUntransformedArrowCap(arrow1Type, (double)arrow1Size / (double)edgeThickness)) != null) {
                this.m_xformUtil.setTransform(cosTheta1, sinTheta1, -sinTheta1, cosTheta1, this.m_edgePtsBuff[(this.m_edgePtsCount - 1) * 6 - 4], this.m_edgePtsBuff[(this.m_edgePtsCount - 1) * 6 - 3]);
                this.m_g2d.transform(this.m_xformUtil);
                this.m_g2d.scale(edgeThickness, edgeThickness);
                this.m_g2d.fill(arrow1Cap);
                this.m_g2d.setTransform(this.m_currNativeXform);
            }
        }
        if ((arrow0 = this.computeUntransformedArrow(arrow0Type)) != null) {
            this.m_xformUtil.setTransform(cosTheta0, sinTheta0, -sinTheta0, cosTheta0, this.m_edgePtsBuff[0], this.m_edgePtsBuff[1]);
            this.m_g2d.transform(this.m_xformUtil);
            this.m_g2d.scale(arrow0Size, arrow0Size);
            this.m_g2d.setPaint(arrow0Paint);
            this.m_g2d.fill(arrow0);
            this.m_g2d.setTransform(this.m_currNativeXform);
        }
        if ((arrow1 = this.computeUntransformedArrow(arrow1Type)) != null) {
            this.m_xformUtil.setTransform(cosTheta1, sinTheta1, -sinTheta1, cosTheta1, this.m_edgePtsBuff[(this.m_edgePtsCount - 1) * 6 - 2], this.m_edgePtsBuff[(this.m_edgePtsCount - 1) * 6 - 1]);
            this.m_g2d.transform(this.m_xformUtil);
            this.m_g2d.scale(arrow1Size, arrow1Size);
            this.m_g2d.setPaint(arrow1Paint);
            this.m_g2d.fill(arrow1);
            this.m_g2d.setTransform(this.m_currNativeXform);
        }
    }

    private final void edgeFullDebug(byte arrow0Type, float arrow0Size, byte arrow1Type, float arrow1Size, Stroke edgeStroke, float edgeThickness, EdgeAnchors anchors) {
        this.checkDispatchThread();
        this.checkCleared();
        if (!(edgeThickness >= 0.0f)) {
            throw new IllegalArgumentException("edgeThickness < 0");
        }
        if (!arrows.containsKey(arrow0Type)) {
            throw new IllegalArgumentException("arrow0Type is not recognized");
        }
        if (arrow0Type != -1 && !(arrow0Size >= edgeThickness)) {
            throw new IllegalArgumentException("arrow size must be at least as large as edge thickness");
        }
        if (!arrows.containsKey(arrow1Type)) {
            throw new IllegalArgumentException("arrow1Type is not recognized");
        }
        if (arrow1Type != -1 && !(arrow1Size >= edgeThickness)) {
            throw new IllegalArgumentException("arrow size must be at least as large as edge thickness");
        }
        if (anchors.numAnchors() > 64) {
            throw new IllegalArgumentException("at most MAX_EDGE_ANCHORS (64) edge anchors can be specified");
        }
    }

    private final void drawSimpleEdgeFull(byte arrow0Type, float arrow0Size, Paint arrow0Paint, byte arrow1Type, float arrow1Size, Paint arrow1Paint, float x0, float y0, float x1, float y1, float edgeThickness, Stroke edgeStroke, Paint edgePaint) {
        Shape arrow1;
        Shape arrow0;
        int simpleSegment;
        double y1Adj;
        double len = Math.sqrt(((double)x1 - (double)x0) * ((double)x1 - (double)x0) + ((double)y1 - (double)y0) * ((double)y1 - (double)y0));
        if (len == 0.0) {
            return;
        }
        double t0 = GraphGraphics.getT(arrow0Type) * (double)arrow0Size / len;
        double x0Adj = t0 * ((double)x1 - (double)x0) + (double)x0;
        double y0Adj = t0 * ((double)y1 - (double)y0) + (double)y0;
        double t1 = GraphGraphics.getT(arrow1Type) * (double)arrow1Size / len;
        double x1Adj = t1 * ((double)x0 - (double)x1) + (double)x1;
        if (((double)x1 - (double)x0) * (x1Adj - x0Adj) + ((double)y1 - (double)y0) * ((y1Adj = t1 * ((double)y0 - (double)y1) + (double)y1) - y0Adj) > 0.0) {
            simpleSegment = arrow0Type == -1 && arrow1Type == -1 ? 1 : -1;
            this.m_g2d.setStroke(edgeStroke);
            this.m_line2d.setLine(x0Adj, y0Adj, x1Adj, y1Adj);
            this.m_g2d.setPaint(edgePaint);
            this.m_g2d.draw(this.m_line2d);
            if (simpleSegment > 0) {
                return;
            }
        } else {
            simpleSegment = 0;
        }
        double cosTheta = ((double)x0 - (double)x1) / len;
        double sinTheta = ((double)y0 - (double)y1) / len;
        if (simpleSegment < 0 && edgeStroke instanceof BasicStroke) {
            Shape arrow1Cap;
            Shape arrow0Cap = this.computeUntransformedArrowCap(arrow0Type, (double)arrow0Size / (double)edgeThickness);
            if (arrow0Cap != null) {
                this.m_xformUtil.setTransform(cosTheta, sinTheta, -sinTheta, cosTheta, x0Adj, y0Adj);
                this.m_g2d.transform(this.m_xformUtil);
                this.m_g2d.scale(edgeThickness, edgeThickness);
                this.m_g2d.fill(arrow0Cap);
                this.m_g2d.setTransform(this.m_currNativeXform);
            }
            if ((arrow1Cap = this.computeUntransformedArrowCap(arrow1Type, (double)arrow1Size / (double)edgeThickness)) != null) {
                this.m_xformUtil.setTransform(-cosTheta, -sinTheta, sinTheta, -cosTheta, x1Adj, y1Adj);
                this.m_g2d.transform(this.m_xformUtil);
                this.m_g2d.scale(edgeThickness, edgeThickness);
                this.m_g2d.fill(arrow1Cap);
                this.m_g2d.setTransform(this.m_currNativeXform);
            }
        }
        if ((arrow0 = this.computeUntransformedArrow(arrow0Type)) != null) {
            this.m_xformUtil.setTransform(cosTheta, sinTheta, -sinTheta, cosTheta, x0, y0);
            this.m_g2d.transform(this.m_xformUtil);
            this.m_g2d.scale(arrow0Size, arrow0Size);
            this.m_g2d.setPaint(arrow0Paint);
            this.m_g2d.fill(arrow0);
            this.m_g2d.setTransform(this.m_currNativeXform);
        }
        if ((arrow1 = this.computeUntransformedArrow(arrow1Type)) != null) {
            this.m_xformUtil.setTransform(-cosTheta, -sinTheta, sinTheta, -cosTheta, x1, y1);
            this.m_g2d.transform(this.m_xformUtil);
            this.m_g2d.scale(arrow1Size, arrow1Size);
            this.m_g2d.setPaint(arrow1Paint);
            this.m_g2d.fill(arrow1);
            this.m_g2d.setTransform(this.m_currNativeXform);
        }
    }

    public final boolean getEdgePath(byte arrow0Type, float arrow0Size, byte arrow1Type, float arrow1Size, float x0, float y0, EdgeAnchors anchors, float x1, float y1, GeneralPath path) {
        byte arrow1;
        byte arrow0;
        double curveFactor = CURVE_ELLIPTICAL;
        if (anchors == null) {
            anchors = this.m_noAnchors;
        }
        if (this.m_debug) {
            this.checkDispatchThread();
            if (!arrows.containsKey(arrow0Type)) {
                throw new IllegalArgumentException("arrow0Type is not recognized");
            }
            if (!arrows.containsKey(arrow1Type)) {
                throw new IllegalArgumentException("arrow1Type is not recognized");
            }
            if (anchors.numAnchors() > 64) {
                throw new IllegalArgumentException("at most MAX_EDGE_ANCHORS (64) edge anchors can be specified");
            }
        }
        if (!this.computeCubicPolyEdgePath(arrow0 = arrow0Type, arrow0 == -1 ? 0.0f : arrow0Size, arrow1 = arrow1Type, arrow1 == -1 ? 0.0f : arrow1Size, x0, y0, anchors, x1, y1, curveFactor)) {
            if (this.m_edgePtsCount == 2) {
                path.reset();
                path.moveTo((float)this.m_edgePtsBuff[0], (float)this.m_edgePtsBuff[1]);
                path.lineTo((float)this.m_edgePtsBuff[2], (float)this.m_edgePtsBuff[3]);
                return true;
            }
            return false;
        }
        path.reset();
        path.moveTo((float)this.m_edgePtsBuff[0], (float)this.m_edgePtsBuff[1]);
        path.lineTo((float)this.m_edgePtsBuff[2], (float)this.m_edgePtsBuff[3]);
        int inx = 4;
        int count = (this.m_edgePtsCount - 1) * 6 - 2;
        while (inx < count) {
            path.curveTo((float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++], (float)this.m_edgePtsBuff[inx++]);
        }
        path.lineTo((float)this.m_edgePtsBuff[count], (float)this.m_edgePtsBuff[count + 1]);
        return true;
    }

    private final Shape computeUntransformedArrow(byte arrowType) {
        Arrow a = arrows.get(arrowType);
        if (a != null) {
            return a.getArrowShape();
        }
        return null;
    }

    private final Shape computeUntransformedArrowCap(byte arrowType, double ratio) {
        Arrow a = arrows.get(arrowType);
        if (a != null) {
            return a.getCapShape(ratio);
        }
        return null;
    }

    private static final double getT(byte arrowType) {
        Arrow a = arrows.get(arrowType);
        if (a != null) {
            return a.getTOffset();
        }
        return 0.125;
    }

    private final boolean computeCubicPolyEdgePath(byte arrow0Type, float arrow0Size, byte arrow1Type, float arrow1Size, float x0, float y0, EdgeAnchors anchors, float x1, float y1, double curveFactor) {
        int numAnchors = anchors.numAnchors();
        this.m_edgePtsBuff[0] = x0;
        this.m_edgePtsBuff[1] = y0;
        this.m_edgePtsCount = 1;
        int anchorInx = 0;
        while (anchorInx < numAnchors) {
            anchors.getAnchor(anchorInx++, this.m_floatBuff, 0);
            if (this.m_floatBuff[0] == x0 && this.m_floatBuff[1] == y0) continue;
            this.m_edgePtsBuff[2] = this.m_floatBuff[0];
            this.m_edgePtsBuff[3] = this.m_floatBuff[1];
            this.m_edgePtsCount = 2;
            break;
        }
        while (anchorInx < numAnchors) {
            anchors.getAnchor(anchorInx++, this.m_floatBuff, 0);
            this.m_edgePtsBuff[this.m_edgePtsCount * 2] = this.m_floatBuff[0];
            this.m_edgePtsBuff[this.m_edgePtsCount * 2 + 1] = this.m_floatBuff[1];
            ++this.m_edgePtsCount;
        }
        this.m_edgePtsBuff[this.m_edgePtsCount * 2] = x1;
        this.m_edgePtsBuff[this.m_edgePtsCount * 2 + 1] = y1;
        ++this.m_edgePtsCount;
        while (this.m_edgePtsCount > 1 && this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 2] == this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 4] && this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 1] == this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 3]) {
            --this.m_edgePtsCount;
        }
        if (this.m_edgePtsCount < 3) {
            return false;
        }
        int edgePtsCount = this.m_edgePtsCount--;
        this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 2] = this.m_edgePtsBuff[this.m_edgePtsCount * 2];
        this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 1] = this.m_edgePtsBuff[this.m_edgePtsCount * 2 + 1];
        double dx = this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 2] - this.m_edgePtsBuff[this.m_edgePtsCount * 2];
        double dy = this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 1] - this.m_edgePtsBuff[this.m_edgePtsCount * 2 + 1];
        double len = Math.sqrt(dx * dx + dy * dy);
        this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 4] = this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 2] + (dx /= len) * (double)arrow1Size * GraphGraphics.getT(arrow1Type);
        this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 3] = this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 1] + (dy /= len) * (double)arrow1Size * GraphGraphics.getT(arrow1Type);
        double candX1 = this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 4] + dx * 2.0 * (double)arrow1Size;
        double candX2 = this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 4] + curveFactor * (this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 2] - this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 4]);
        this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 6] = Math.abs(candX1 - this.m_edgePtsBuff[this.m_edgePtsCount * 2]) > Math.abs(candX2 - this.m_edgePtsBuff[this.m_edgePtsCount * 2]) ? candX1 : candX2;
        double candY1 = this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 3] + dy * 2.0 * (double)arrow1Size;
        double candY2 = this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 3] + curveFactor * (this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 1] - this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 3]);
        this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 5] = Math.abs(candY1 - this.m_edgePtsBuff[this.m_edgePtsCount * 2 + 1]) > Math.abs(candY2 - this.m_edgePtsBuff[this.m_edgePtsCount * 2 + 1]) ? candY1 : candY2;
        while (this.m_edgePtsCount > 2) {
            --this.m_edgePtsCount;
            double midX = (this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 2] + this.m_edgePtsBuff[this.m_edgePtsCount * 2]) / 2.0;
            double midY = (this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 1] + this.m_edgePtsBuff[this.m_edgePtsCount * 2 + 1]) / 2.0;
            this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 2] = midX + (this.m_edgePtsBuff[this.m_edgePtsCount * 2] - midX) * curveFactor;
            this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 1] = midY + (this.m_edgePtsBuff[this.m_edgePtsCount * 2 + 1] - midY) * curveFactor;
            this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 4] = midX;
            this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 3] = midY;
            this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 6] = midX + (this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 2] - midX) * curveFactor;
            this.m_edgePtsBuff[this.m_edgePtsCount * 6 - 5] = midY + (this.m_edgePtsBuff[this.m_edgePtsCount * 2 - 1] - midY) * curveFactor;
        }
        dx = this.m_edgePtsBuff[2] - this.m_edgePtsBuff[0];
        dy = this.m_edgePtsBuff[3] - this.m_edgePtsBuff[1];
        len = Math.sqrt(dx * dx + dy * dy);
        double segStartX = this.m_edgePtsBuff[0] + (dx /= len) * (double)arrow0Size * GraphGraphics.getT(arrow0Type);
        double segStartY = this.m_edgePtsBuff[1] + (dy /= len) * (double)arrow0Size * GraphGraphics.getT(arrow0Type);
        double candX12 = segStartX + dx * 2.0 * (double)arrow0Size;
        double candX22 = segStartX + curveFactor * (this.m_edgePtsBuff[2] - segStartX);
        this.m_edgePtsBuff[4] = Math.abs(candX12 - this.m_edgePtsBuff[0]) > Math.abs(candX22 - this.m_edgePtsBuff[0]) ? candX12 : candX22;
        double candY12 = segStartY + dy * 2.0 * (double)arrow0Size;
        double candY22 = segStartY + curveFactor * (this.m_edgePtsBuff[3] - segStartY);
        this.m_edgePtsBuff[5] = Math.abs(candY12 - this.m_edgePtsBuff[1]) > Math.abs(candY22 - this.m_edgePtsBuff[1]) ? candY12 : candY22;
        this.m_edgePtsBuff[2] = segStartX;
        this.m_edgePtsBuff[3] = segStartY;
        this.m_edgePtsCount = edgePtsCount;
        return true;
    }

    public final boolean computeEdgeIntersection(byte nodeShape, float xMin, float yMin, float xMax, float yMax, float offset, float ptX, float ptY, float[] returnVal) {
        NodeShape ns;
        if (this.m_debug) {
            this.checkDispatchThread();
            this.checkOrder(xMin, xMax, "x");
            this.checkOrder(yMin, yMax, "y");
            if (offset < 0.0f) {
                throw new IllegalArgumentException("offset < 0");
            }
        }
        if ((ns = nodeShapes.get(nodeShape)) == null) {
            return false;
        }
        return ns.computeEdgeIntersection(xMin, yMin, xMax, yMax, ptX, ptY, returnVal);
    }

    public final void drawTextLow(Font font, String text, float xCenter, float yCenter, Color color) {
        if (this.m_debug) {
            this.checkDispatchThread();
            this.checkCleared();
            if (color.getAlpha() != 255) {
                throw new IllegalStateException("color is not opaque");
            }
        }
        if (this.m_gMinimal == null) {
            this.makeMinimalGraphics();
        }
        this.m_ptsBuff[0] = xCenter;
        this.m_ptsBuff[1] = yCenter;
        this.m_currXform.transform(this.m_ptsBuff, 0, this.m_ptsBuff, 0, 1);
        this.m_gMinimal.setFont(font);
        FontMetrics fMetrics = this.m_gMinimal.getFontMetrics();
        this.m_gMinimal.setColor(color);
        this.m_gMinimal.drawString(text, (int)(-0.5 * (double)fMetrics.stringWidth(text) + this.m_ptsBuff[0]), (int)(0.5 * (double)fMetrics.getHeight() - (double)fMetrics.getDescent() + this.m_ptsBuff[1]));
    }

    public final FontRenderContext getFontRenderContextLow() {
        if (this.m_debug) {
            this.checkDispatchThread();
        }
        if (this.m_gMinimal == null) {
            this.makeMinimalGraphics();
        }
        return this.m_gMinimal.getFontRenderContext();
    }

    public final void drawTextFull(Font font, double scaleFactor, String text, float xCenter, float yCenter, float theta, Paint paint, boolean drawTextAsShape) {
        if (this.m_debug) {
            this.checkDispatchThread();
            this.checkCleared();
            if (scaleFactor < 0.0) {
                throw new IllegalArgumentException("scaleFactor must be positive");
            }
        }
        this.m_g2d.translate(xCenter, yCenter);
        this.m_g2d.scale(scaleFactor, scaleFactor);
        if (theta != 0.0f) {
            this.m_g2d.rotate(theta);
        }
        this.m_g2d.setPaint(paint);
        if (drawTextAsShape) {
            if (text.length() > this.m_charBuff.length) {
                this.m_charBuff = new char[Math.max(this.m_charBuff.length * 2, text.length())];
            }
            text.getChars(0, text.length(), this.m_charBuff, 0);
            GlyphVector glyphV = font.layoutGlyphVector(this.getFontRenderContextFull(), this.m_charBuff, 0, text.length(), 4);
            Rectangle2D glyphBounds = glyphV.getLogicalBounds();
            this.m_g2d.translate(-glyphBounds.getCenterX(), -glyphBounds.getCenterY());
            this.m_g2d.fill(glyphV.getOutline());
        } else {
            Rectangle2D textBounds = font.getStringBounds(text, this.getFontRenderContextFull());
            this.m_g2d.translate(-textBounds.getCenterX(), -textBounds.getCenterY());
            this.m_g2d.setFont(font);
            this.m_g2d.drawString(text, 0.0f, 0.0f);
        }
        this.m_g2d.setTransform(this.m_currNativeXform);
    }

    public final FontRenderContext getFontRenderContextFull() {
        if (this.m_debug) {
            this.checkDispatchThread();
        }
        return this.m_fontRenderContextFull;
    }

    public final void drawCustomGraphicFull(Shape shape, float xOffset, float yOffset, Paint paint) {
        if (this.m_debug) {
            this.checkDispatchThread();
            this.checkCleared();
        }
        this.m_g2d.translate(xOffset, yOffset);
        if (paint instanceof TexturePaint) {
            BufferedImage bImg = ((TexturePaint)paint).getImage();
            this.m_g2d.drawImage(bImg, shape.getBounds().x, shape.getBounds().y, shape.getBounds().width, shape.getBounds().height, null);
        } else {
            this.m_g2d.setPaint(paint);
            this.m_g2d.fill(shape);
        }
        this.m_g2d.setTransform(this.m_currNativeXform);
    }

    private Stroke getStroke(float borderWidth) {
        Stroke s = borderStrokes.get(Float.valueOf(borderWidth));
        if (s == null) {
            s = new BasicStroke(borderWidth);
            borderStrokes.put(Float.valueOf(borderWidth), s);
        }
        return s;
    }

    private void checkDispatchThread() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("calling thread is not AWT event dispatcher");
        }
    }

    private void checkCleared() {
        if (!this.m_cleared) {
            throw new IllegalStateException("clear() has not been called previously");
        }
    }

    private void checkOrder(float min, float max, String id) {
        if (!(min < max)) {
            throw new IllegalArgumentException(id + "Min not less than " + id + "Max");
        }
    }

    static {
        CURVE_ELLIPTICAL = 4.0 * (Math.sqrt(2.0) - 1.0) / 3.0;
        borderStrokes = new HashMap<Float, Stroke>();
        dummyGraphics = new GraphGraphics(null, false);
        nodeShapes = new HashMap<Byte, NodeShape>();
        nodeShapes.put((byte)0, new RectangleNodeShape());
        nodeShapes.put((byte)2, new EllipseNodeShape());
        nodeShapes.put((byte)6, new RoundedRectangleNodeShape());
        nodeShapes.put((byte)1, new DiamondNodeShape());
        nodeShapes.put((byte)3, new HexagonNodeShape());
        nodeShapes.put((byte)4, new OctagonNodeShape());
        nodeShapes.put((byte)5, new ParallelogramNodeShape());
        nodeShapes.put((byte)7, new TriangleNodeShape());
        nodeShapes.put((byte)8, new VeeNodeShape());
        arrows = new HashMap<Byte, Arrow>();
        arrows.put((byte)-1, new NoArrow());
        arrows.put((byte)-2, new DeltaArrow());
        arrows.put((byte)-4, new DiscArrow());
        arrows.put((byte)-3, new DiamondArrow());
        arrows.put((byte)-5, new TeeArrow());
        arrows.put((byte)-8, new ArrowheadArrow());
        arrows.put((byte)-6, new HalfTopArrow());
        arrows.put((byte)-7, new HalfBottomArrow());
    }
}

