/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.preferences;

import cytoscape.CytoscapeInit;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.PluginManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class PluginsTableModel
extends AbstractTableModel {
    static int[] columnWidth = new int[]{400};
    static int[] alignment = new int[]{2};
    private Properties properties;
    TreeSet pluginsSet = new TreeSet();
    static String[] columnHeader = new String[]{"Plugin Location"};
    boolean pluginsFromCommandLineLoadedAndSaved = false;
    private static CyLogger logger = CyLogger.getLogger(PluginsTableModel.class);

    public PluginsTableModel() {
        this.properties = new Properties();
        if (CytoscapeInit.getProperties().get("plugins") != null) {
            this.properties.put("plugins", CytoscapeInit.getProperties().get("plugins"));
        }
        this.loadProperties();
    }

    public void loadProperties() {
        this.pluginsSet.clear();
        if (this.getProperty("plugins") != null) {
            String[] pargs = this.getProperty("plugins", "").split(",");
            for (int i = 0; i < pargs.length; ++i) {
                this.addPlugin(pargs[i]);
            }
        }
        if (!this.pluginsFromCommandLineLoadedAndSaved) {
            HashSet<URL> plugins = new HashSet<URL>(PluginManager.getPluginURLs());
            for (URL url : plugins) {
                this.addPlugin(url);
            }
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void addPluginToPropertyString(String newPlugin) {
        String tempPlugins = this.properties.getProperty("plugins");
        if (tempPlugins != null) {
            this.properties.setProperty("plugins", this.cullDuplicates(tempPlugins + "," + newPlugin));
        } else {
            this.properties.setProperty("plugins", newPlugin);
        }
    }

    String cullDuplicates(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        HashSet<String> hashSet = new HashSet<String>();
        while (st.hasMoreTokens()) {
            hashSet.add(st.nextToken());
        }
        String newString = new String();
        Iterator it = hashSet.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            sb.append((String)it.next());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public void deletePlugins(String[] deletedPlugins) {
        String tempPlugins = this.properties.getProperty("plugins");
        for (int k = 0; k < deletedPlugins.length; ++k) {
            String value = deletedPlugins[k];
            if (value.startsWith("file:")) {
                value = value.substring(5);
            } else if (value.startsWith("jar:")) {
                value = value.substring(4);
            } else if (value.startsWith("http\\:")) {
                value = value.substring(0, 3) + value.substring(5);
            }
            if (tempPlugins != null) {
                String[] plugins = tempPlugins.split(",");
                String returnString = null;
                for (int i = 0; i < plugins.length; ++i) {
                    if (value.compareTo(plugins[i]) == 0) continue;
                    returnString = returnString == null ? new String(plugins[i]) : new String(returnString + "," + plugins[i]);
                }
                if (returnString == null) {
                    this.properties.remove("plugins");
                } else {
                    this.properties.setProperty("plugins", returnString);
                }
            }
            this.pluginsSet.remove(value);
        }
    }

    public void addPlugin(String pluginString) {
        String[] plugin = pluginString.split(",");
        for (int i = 0; i < plugin.length; ++i) {
            try {
                URL url;
                if (plugin[i].startsWith("http")) {
                    plugin[i] = "jar:" + plugin[i] + "!/";
                    url = new URL(plugin[i]);
                } else {
                    url = plugin[i].startsWith("file") || plugin[i].startsWith("jar") ? new URL(plugin[i]) : new URL("file", "", plugin[i]);
                }
                this.addPlugin(url);
                continue;
            }
            catch (Exception ue) {
                logger.warn("Error: cannot construct URL from: " + plugin[i]);
            }
        }
    }

    public void addPlugin(URL u) {
        if (u != null) {
            String path = u.getPath();
            if (path.endsWith("!/")) {
                path = path.substring(0, path.length() - 2);
            }
            this.pluginsSet.add(path);
            this.addPluginToPropertyString(path);
        }
    }

    public String getColumnName(int col) {
        return columnHeader[col];
    }

    public void save(Properties saveToProps) {
        saveToProps.putAll((Map<?, ?>)this.properties);
        this.pluginsFromCommandLineLoadedAndSaved = true;
    }

    public void restore(Properties restoreFromProps) {
        this.properties.clear();
        if (restoreFromProps.getProperty("plugins") != null) {
            this.properties.put("plugins", restoreFromProps.getProperty("plugins"));
            this.loadProperties();
        }
    }

    public int getColumnCount() {
        return columnHeader.length;
    }

    public Object getValueAt(int row, int col) {
        String retVal2 = new String("");
        int index = 0;
        for (String retVal2 : this.pluginsSet) {
            if (index == row) break;
            ++index;
        }
        return retVal2;
    }

    public int getRowCount() {
        return this.pluginsSet.size();
    }

    public boolean validateNewPlugins(String value, Vector listOfDuplicates, Vector listOfNew) {
        listOfDuplicates.clear();
        listOfNew.clear();
        try {
            String[] path = value.split(",");
            for (int i = 0; i < path.length; ++i) {
                File newFile = new File(path[i]);
                int numRows = this.getRowCount();
                boolean isDuplicate = false;
                for (int j = 0; j < numRows; ++j) {
                    String currentFileStr = (String)this.getValueAt(j, 0);
                    if (currentFileStr.equals(path[i])) {
                        listOfDuplicates.add(path[i]);
                        isDuplicate = true;
                        continue;
                    }
                    File currentFile = new File(currentFileStr);
                    if (!currentFile.getCanonicalPath().equals(newFile.getCanonicalPath())) continue;
                    listOfDuplicates.add(path[i]);
                    isDuplicate = true;
                }
                if (isDuplicate) continue;
                listOfNew.add(path[i]);
            }
        }
        catch (IOException ioe) {
            logger.warn("Failed to validate new plugins: " + ioe.getMessage(), ioe);
        }
        return listOfDuplicates.size() > 0;
    }
}

