/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.preferences;

import cytoscape.bookmarks.Bookmarks;
import cytoscape.bookmarks.DataSource;
import cytoscape.util.BookmarksUtil;
import cytoscape.util.URLUtil;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class EditBookmarkDialog
extends JDialog {
    private JButton cancelButton;
    private JLabel categoryLabel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField nameTextField;
    private JButton okButton;
    private JTextField urlTextField;
    private final JDialog parent;
    private final Bookmarks bookmarks;
    private final String categoryName;
    private final String mode;
    private DataSource dataSource;

    public EditBookmarkDialog(JDialog parent, boolean modal, Bookmarks bookmarks, String categoryName, String mode, DataSource dataSource) {
        super((Dialog)parent, modal);
        this.parent = parent;
        this.bookmarks = bookmarks;
        this.categoryName = categoryName;
        this.mode = mode;
        this.dataSource = dataSource;
        this.initComponents();
        this.categoryLabel.setText(categoryName);
        if (mode.equalsIgnoreCase("new")) {
            this.setTitle("Add New Bookmark");
        } else {
            this.setTitle("Edit Bookmark");
            this.nameTextField.setText(dataSource.getName());
            this.urlTextField.setText(dataSource.getHref());
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.categoryLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.nameTextField = new JTextField();
        this.urlTextField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Bookmark");
        this.jLabel1.setText("Category:");
        this.categoryLabel.setText("******************");
        this.jLabel3.setText("Name:");
        this.jLabel4.setText("URL:");
        this.okButton.setText("Ok");
        this.okButton.setSelected(true);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (EditBookmarkDialog.this.mode.equalsIgnoreCase("new")) {
                    EditBookmarkDialog.this.okButtonNewActionPerformed(evt);
                } else {
                    EditBookmarkDialog.this.okButtonEditActionPerformed(evt);
                }
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditBookmarkDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(layout.createParallelGroup(1, false).add(layout.createSequentialGroup().add(32, 32, 32).add(this.jLabel1).addPreferredGap(0)).add(2, layout.createSequentialGroup().addContainerGap(42, Short.MAX_VALUE).add(layout.createParallelGroup(2).add(this.jLabel4).add(this.jLabel3)).add(20, 20, 20))).add(layout.createParallelGroup(1).add(this.categoryLabel, -2, 112, -2).add(layout.createParallelGroup(2, false).add(1, this.urlTextField).add(1, this.nameTextField, -1, 608, Short.MAX_VALUE).add(layout.createSequentialGroup().add(441, 441, 441).add(this.okButton).addPreferredGap(0).add(this.cancelButton)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(22, 22, 22).add(layout.createParallelGroup(3).add(this.jLabel1, -2, 16, -2).add(this.categoryLabel)).addPreferredGap(1).add(layout.createParallelGroup(3).add(this.nameTextField, -2, -1, -2).add(this.jLabel3)).add(28, 28, 28).add(layout.createParallelGroup(3).add(this.jLabel4).add(this.urlTextField, -2, -1, -2)).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void okButtonNewActionPerformed(ActionEvent evt) {
        URL url;
        String name = this.nameTextField.getText().trim();
        String urlCandidate = this.urlTextField.getText().trim();
        if (name.equals("") || urlCandidate.equals("")) {
            JOptionPane.showMessageDialog(this.parent, "Please provide a name and URL!", "Warning", 1);
            return;
        }
        if (URLUtil.isValid(urlCandidate)) {
            try {
                url = new URL(urlCandidate);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("We should never get here!");
            }
        } else {
            JOptionPane.showMessageDialog(this.parent, "Invalid URL!", "Warning", 1);
            return;
        }
        DataSource theDataSource = new DataSource();
        theDataSource.setName(name);
        theDataSource.setHref(urlCandidate);
        if (BookmarksUtil.isInBookmarks(url, this.categoryName, theDataSource)) {
            JOptionPane.showMessageDialog(this.parent, "Duplicate bookmark!", "Warning", 1);
            return;
        }
        BookmarksUtil.saveBookmark(this.bookmarks, this.categoryName, theDataSource);
        this.dataSource = theDataSource;
        this.dispose();
    }

    private void okButtonEditActionPerformed(ActionEvent evt) {
        String name = this.nameTextField.getText().trim();
        String url = this.urlTextField.getText().trim();
        if (name.equals("") || url.equals("")) {
            JOptionPane.showMessageDialog(this.parent, "Please provide a name and URL!", "Warning", 1);
            return;
        }
        if (!URLUtil.isValid(url)) {
            JOptionPane.showMessageDialog(this.parent, "Invalid URL!", "Warning", 1);
            return;
        }
        if (this.dataSource.getName().equalsIgnoreCase(name) && this.dataSource.getHref().equalsIgnoreCase(url)) {
            this.dispose();
            return;
        }
        if (!URLUtil.isValid(url)) {
            JOptionPane.showMessageDialog(this.parent, "Invalid URL", "Warning", 1);
            return;
        }
        if (!name.equalsIgnoreCase(this.dataSource.getName())) {
            DataSource newDataSource = new DataSource();
            newDataSource.setName(name);
            newDataSource.setHref(url);
            if (BookmarksUtil.isInBookmarks(this.bookmarks, this.categoryName, newDataSource)) {
                JOptionPane.showMessageDialog(this.parent, "Bookmark with this name already existed!", "Warning", 1);
                return;
            }
            BookmarksUtil.deleteBookmark(this.bookmarks, this.categoryName, this.dataSource);
            BookmarksUtil.saveBookmark(this.bookmarks, this.categoryName, newDataSource);
        } else {
            BookmarksUtil.deleteBookmark(this.bookmarks, this.categoryName, this.dataSource);
            this.dataSource.setHref(url);
            BookmarksUtil.saveBookmark(this.bookmarks, this.categoryName, this.dataSource);
        }
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

