/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.plugins;

import cytoscape.CytoscapeVersion;
import cytoscape.dialogs.plugins.TreeNode;
import cytoscape.plugin.DownloadableInfo;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    Icon warningIcon;
    Icon okIcon;

    public TreeCellRenderer(Icon warningLeafIcon, Icon okLeafIcon) {
        this.warningIcon = warningLeafIcon;
        this.okIcon = okLeafIcon;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (((TreeNode)value).getObject() != null) {
            if (leaf && this.isOutdated(value)) {
                this.setIcon(this.warningIcon);
                this.setToolTipText("This plugin is not verified to work with the current version of Cytoscape.");
            } else if (leaf && !this.isOutdated(value)) {
                this.setIcon(this.okIcon);
                this.setToolTipText("Verified to work in " + CytoscapeVersion.version);
            } else {
                this.setToolTipText(null);
            }
        }
        return this;
    }

    private boolean isOutdated(Object value) {
        TreeNode node = (TreeNode)value;
        DownloadableInfo infoObj = node.getObject();
        return infoObj != null && !infoObj.isPluginCompatibleWithCurrent();
    }
}

