/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.logger;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogHandler;
import cytoscape.logger.LogLevel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.jdesktop.layout.GroupLayout;

public class LoggerDialog
extends JDialog
implements CyLogHandler,
PropertyChangeListener {
    private static LoggerDialog dialog;
    private Map<LogLevel, List<String>> messageMap;
    private Map<LogLevel, JScrollPane> logTabMap;
    private boolean messageAdded = false;
    private JButton clearButton;
    private JButton closeButton;
    private JTabbedPane logTabs;

    protected LoggerDialog(JFrame owner) {
        super((Frame)owner, false);
        this.init();
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public static LoggerDialog getLoggerDialog() {
        if (dialog == null) {
            dialog = new LoggerDialog(Cytoscape.getDesktop());
            dialog.setTitle("Cytoscape Error Console");
        }
        return dialog;
    }

    private void init() {
        this.messageMap = new HashMap<LogLevel, List<String>>();
        this.logTabMap = new HashMap<LogLevel, JScrollPane>();
        this.initComponents();
        this.setSize(this.getWidth() * 2, this.getHeight() * 2);
    }

    private void initComponents() {
        this.closeButton = new JButton();
        this.clearButton = new JButton();
        this.logTabs = new JTabbedPane();
        this.setDefaultCloseOperation(2);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoggerDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.clearButton.setText("Clear Messages");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LoggerDialog.this.clearButtonActionPerformed(evt);
            }
        });
        this.logTabs.setAutoscrolls(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.logTabs, -1, 380, Short.MAX_VALUE).add(2, layout.createSequentialGroup().add(this.clearButton).addPreferredGap(0).add(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.logTabs, -1, 263, Short.MAX_VALUE).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.closeButton).add(this.clearButton)).addContainerGap()));
        this.pack();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        for (LogLevel key : this.messageMap.keySet()) {
            this.messageMap.get((Object)key).clear();
            ((JEditorPane)this.logTabMap.get((Object)key).getViewport().getView()).setText("");
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void handleLog(LogLevel level, String msg) {
        if (level.getLevel() > 3) {
            return;
        }
        if (level.equals((Object)LogLevel.LOG_DEBUG)) {
            // empty if block
        }
        ArrayList<String> Messages2 = this.messageMap.get((Object)level) != null ? this.messageMap.get((Object)level) : new ArrayList<String>();
        msg = msg.replace("\n", "<br>");
        msg = msg.replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        Messages2.add(msg);
        this.messageMap.put(level, Messages2);
        this.messageAdded = true;
        if (this.isVisible()) {
            JEditorPane MessagePane = this.addTab(level);
            StringBuffer sb = this.createMessages(level);
            MessagePane.setText("");
            MessagePane.setText(sb.toString());
            this.messageAdded = false;
        } else if (level.equals((Object)LogLevel.LOG_ERROR)) {
            this.setVisible(true);
        }
        if ((level == LogLevel.LOG_ERROR || level == LogLevel.LOG_WARN) && this.isVisible()) {
            this.logTabs.setSelectedComponent(this.logTabMap.get((Object)level));
        }
    }

    private JEditorPane addTab(LogLevel level) {
        JEditorPane MessagesPane = null;
        if (this.logTabMap.get((Object)level) != null) {
            JScrollPane ScrollPane = this.logTabMap.get((Object)level);
            MessagesPane = (JEditorPane)ScrollPane.getViewport().getView();
        } else {
            JScrollPane ScrollPane = new JScrollPane();
            this.logTabMap.put(level, ScrollPane);
            this.logTabs.addTab(level.getPrettyName(), ScrollPane);
            MessagesPane = new JEditorPane();
            ScrollPane.setViewportView(MessagesPane);
            MessagesPane.setEditable(false);
            MessagesPane.setContentType("text/html");
        }
        return MessagesPane;
    }

    private void addEmptyMessage() {
        this.addTab(LogLevel.LOG_ERROR);
    }

    private StringBuffer createMessages(LogLevel level) {
        StringBuffer sb = new StringBuffer();
        String color = "#333333";
        if (level.equals((Object)LogLevel.LOG_ERROR)) {
            color = "#ff0000";
        } else if (level.equals((Object)LogLevel.LOG_WARN)) {
            color = "#ff4500";
        }
        sb.append("<html><style type='text/css'>");
        sb.append("body,th,td,div,p,h1,h2,li,dt,dd ");
        sb.append("{ font-family: Tahoma, \"Gill Sans\", Arial, sans-serif; }");
        sb.append("body { margin: 0px; color: " + color + "; background-color: #ffffff; }");
        sb.append("#indent { padding-left: 30px; }");
        sb.append("ul {list-style-type: none}");
        sb.append("</style><body>");
        sb.append("<table width='100%' cellspacing='5'>");
        int line = this.messageMap.get((Object)level).size();
        for (int i = this.messageMap.get((Object)level).size() - 1; i >= 0; --i) {
            sb.append("<tr><td width='5%'>" + line + "</td><td width='95%'>");
            sb.append(this.messageMap.get((Object)level).get(i));
            sb.append("</td></tr>");
            sb.append("<tr><td colspan='2'><hr></td></tr>");
            --line;
        }
        sb.append("</table></body></html>");
        return sb;
    }

    public void setVisible(boolean vis) {
        if (this.messageMap.size() <= 0) {
            this.addEmptyMessage();
        }
        if (this.messageAdded) {
            Set<LogLevel> levels = this.messageMap.keySet();
            for (LogLevel level : levels) {
                JEditorPane MessagePane = this.addTab(level);
                StringBuffer sb = this.createMessages(level);
                MessagePane.setContentType("text/html");
                MessagePane.setText(sb.toString());
            }
            this.messageAdded = false;
        }
        super.setVisible(vis);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equalsIgnoreCase(Cytoscape.SESSION_LOADED)) {
            try {
                this.clearButtonActionPerformed(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        LoggerDialog dialog = LoggerDialog.getLoggerDialog();
        dialog.setVisible(true);
        dialog.handleLog(LogLevel.LOG_ERROR, "Error, error!");
        dialog.handleLog(LogLevel.LOG_ERROR, "It's gonna blow!!!");
        dialog.handleLog(LogLevel.LOG_WARN, "Canna take much more Cap'n!");
        dialog.handleLog(LogLevel.LOG_WARN, "Foobared");
        dialog.handleLog(LogLevel.LOG_INFO, "Just sayin'...");
    }
}

