/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.readers.MetadataEntries;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataParser {
    public static final String DEFAULT_NETWORK_METADATA_LABEL = "Network Metadata";
    private static final String DEF_URI = "http://www.cytoscape.org/";
    private static final String DEF_TYPE = "Protein-Protein Interaction";
    private static final String DEF_FORMAT = "Cytoscape-XGMML";
    private String metadataLabel;
    private CyNetwork network;
    private CyAttributes networkAttributes;
    private Map rdfAsMap;

    public MetadataParser(CyNetwork network) {
        this(network, DEFAULT_NETWORK_METADATA_LABEL);
    }

    public MetadataParser(CyNetwork network, String metadataLabel) {
        this.metadataLabel = metadataLabel;
        this.network = network;
        this.networkAttributes = Cytoscape.getNetworkAttributes();
        this.rdfAsMap = this.networkAttributes.getMapAttribute(network.getIdentifier(), metadataLabel);
    }

    public Map<String, String> makeNewMetadataMap() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String defSource = CytoscapeInit.getProperties().getProperty("defaultMetadata.source");
        String defType = CytoscapeInit.getProperties().getProperty("defaultMetadata.type");
        String defFormat = CytoscapeInit.getProperties().getProperty("defaultMetadata.format");
        MetadataEntries[] entries = MetadataEntries.values();
        block7: for (int i = 0; i < entries.length; ++i) {
            switch (entries[i]) {
                case DATE: {
                    Date now = new Date();
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    dataMap.put(entries[i].toString(), df.format(now));
                    continue block7;
                }
                case TITLE: {
                    dataMap.put(entries[i].toString(), this.network.getTitle());
                    continue block7;
                }
                case SOURCE: {
                    if (defSource == null) {
                        dataMap.put(entries[i].toString(), DEF_URI);
                        continue block7;
                    }
                    dataMap.put(entries[i].toString(), defSource);
                    continue block7;
                }
                case TYPE: {
                    if (defType == null) {
                        dataMap.put(entries[i].toString(), DEF_TYPE);
                        continue block7;
                    }
                    dataMap.put(entries[i].toString(), defType);
                    continue block7;
                }
                case FORMAT: {
                    if (defFormat == null) {
                        dataMap.put(entries[i].toString(), DEF_FORMAT);
                        continue block7;
                    }
                    dataMap.put(entries[i].toString(), defFormat);
                    continue block7;
                }
                default: {
                    dataMap.put(entries[i].toString(), "N/A");
                }
            }
        }
        return dataMap;
    }

    public Map getMetadataMap() {
        if (this.rdfAsMap == null || this.rdfAsMap.keySet().size() == 0) {
            this.rdfAsMap = this.makeNewMetadataMap();
        }
        return this.rdfAsMap;
    }

    public void setMetadata(MetadataEntries entryName, String value) {
        Map<String, String> metadata = this.networkAttributes.getMapAttribute(this.network.getIdentifier(), this.metadataLabel);
        if (metadata == null) {
            metadata = this.makeNewMetadataMap();
        }
        metadata.put(entryName.toString(), value);
        this.networkAttributes.setMapAttribute(this.network.getIdentifier(), this.metadataLabel, metadata);
        this.rdfAsMap = metadata;
    }
}

