/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.SelectEvent;
import cytoscape.data.SelectEventListener;
import giny.filter.Filter;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.GraphPerspectiveChangeEvent;
import giny.model.GraphPerspectiveChangeListener;
import giny.model.Node;
import giny.model.RootGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFilter
implements Filter,
GraphPerspectiveChangeListener {
    private GraphPerspective graph;
    private final Set<Node> selectedNodes = new HashSet<Node>();
    private final Set<Edge> selectedEdges = new HashSet<Edge>();
    private List listeners = new ArrayList();

    public SelectFilter(GraphPerspective graph) {
        this.graph = graph;
        graph.addGraphPerspectiveChangeListener(this);
    }

    public Set getSelectedNodes() {
        return this.selectedNodes;
    }

    public Set getSelectedEdges() {
        return this.selectedEdges;
    }

    public boolean isSelected(Node node) {
        return this.selectedNodes.contains(node);
    }

    public boolean isSelected(Edge edge) {
        return this.selectedEdges.contains(edge);
    }

    @Override
    public boolean passesFilter(Object o) {
        return this.selectedNodes.contains(o) || this.selectedEdges.contains(o);
    }

    public boolean setSelected(Node node, boolean newState) {
        boolean setChanged;
        if (newState) {
            if (!this.graph.containsNode(node)) {
                return false;
            }
            setChanged = this.selectedNodes.add(node);
            if (setChanged) {
                this.fireEvent(node, true);
            }
        } else {
            setChanged = this.selectedNodes.remove(node);
            if (setChanged) {
                this.fireEvent(node, false);
            }
        }
        return setChanged;
    }

    public boolean setSelected(Edge edge, boolean newState) {
        boolean setChanged;
        if (newState) {
            if (!this.graph.containsEdge(edge)) {
                return false;
            }
            setChanged = this.selectedEdges.add(edge);
            if (setChanged) {
                this.fireEvent(edge, true);
            }
        } else {
            setChanged = this.selectedEdges.remove(edge);
            if (setChanged) {
                this.fireEvent(edge, false);
            }
        }
        return setChanged;
    }

    public Set<Node> setSelectedNodes(Collection<Node> nodesToSet, boolean newState) {
        HashSet<Node> returnSet = new HashSet<Node>();
        if (nodesToSet == null || nodesToSet.size() == 0) {
            return returnSet;
        }
        if (newState) {
            for (Node node : nodesToSet) {
                if (!this.graph.containsNode(node) || !this.selectedNodes.add(node)) continue;
                returnSet.add(node);
            }
            if (returnSet.size() > 0) {
                this.fireEvent(returnSet, true);
            }
        } else {
            for (Node node : nodesToSet) {
                if (!this.selectedNodes.remove(node)) continue;
                returnSet.add(node);
            }
            if (returnSet.size() > 0) {
                this.fireEvent(returnSet, false);
            }
        }
        return returnSet;
    }

    public Set<Edge> setSelectedEdges(Collection<Edge> edgesToSet, boolean newState) {
        HashSet<Edge> edgeReturnSet = new HashSet<Edge>();
        if (edgesToSet == null || edgesToSet.size() == 0) {
            return edgeReturnSet;
        }
        if (newState) {
            for (Edge edge : edgesToSet) {
                if (!this.graph.containsEdge(edge) || !this.selectedEdges.add(edge)) continue;
                edgeReturnSet.add(edge);
            }
            if (edgeReturnSet.size() > 0) {
                this.fireEvent(edgeReturnSet, true);
            }
        } else {
            for (Edge edge : edgesToSet) {
                if (!this.selectedEdges.remove(edge)) continue;
                edgeReturnSet.add(edge);
            }
            if (edgeReturnSet.size() > 0) {
                this.fireEvent(edgeReturnSet, false);
            }
        }
        return edgeReturnSet;
    }

    public Set selectAllNodes() {
        return this.setSelectedNodes(this.graph.nodesList(), true);
    }

    public Set selectAllEdges() {
        return this.setSelectedEdges(this.graph.edgesList(), true);
    }

    public Set unselectAllNodes() {
        return this.setSelectedNodes(this.graph.nodesList(), false);
    }

    public Set unselectAllEdges() {
        return this.setSelectedEdges(this.graph.edgesList(), false);
    }

    @Override
    public void graphPerspectiveChanged(GraphPerspectiveChangeEvent event) {
        HashSet<Node> nodeChanges = null;
        if (event.isNodesHiddenType()) {
            for (Node node : event.getHiddenNodes()) {
                boolean setChanged = this.selectedNodes.remove(node);
                if (!setChanged) continue;
                if (nodeChanges == null) {
                    nodeChanges = new HashSet<Node>();
                }
                nodeChanges.add(node);
            }
        }
        if (nodeChanges != null && nodeChanges.size() > 0) {
            this.fireEvent(nodeChanges, false);
        }
        HashSet<Edge> edgeChanges = null;
        if (event.isEdgesHiddenType()) {
            Object eventSource = event.getSource();
            RootGraph root = eventSource instanceof RootGraph ? (RootGraph)eventSource : ((GraphPerspective)eventSource).getRootGraph();
            int[] indices = event.getHiddenEdgeIndices();
            int eLength = indices.length;
            for (int index = 0; index < eLength; ++index) {
                Edge edge = root.getEdge(indices[index]);
                boolean setChanged = this.selectedEdges.remove(edge);
                if (!setChanged) continue;
                if (edgeChanges == null) {
                    edgeChanges = new HashSet<Edge>();
                }
                edgeChanges.add(edge);
            }
        }
        if (edgeChanges != null && edgeChanges.size() > 0) {
            this.fireEvent(edgeChanges, false);
        }
    }

    public void addSelectEventListener(SelectEventListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectEventListener(SelectEventListener listener) {
        this.listeners.remove(listener);
    }

    public List getSelectEventListeners() {
        return this.listeners;
    }

    protected void fireEvent(Object target, boolean selectOn) {
        SelectEvent event = new SelectEvent(this, target, selectOn);
        for (SelectEventListener listener : this.listeners) {
            listener.onSelectEvent(event);
        }
    }
}

