/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.ImportHandler;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.InteractionsReader;
import cytoscape.util.CyFileFilter;
import cytoscape.util.SIFFileFilter;
import java.io.File;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class ImportHandlerTest
extends TestCase {
    private File DUMMY_SIF_FILE;
    private File DUMMY_XGMML_FILE;
    private File DUMMY_GML_FILE;
    private File DUMMY_XML_FILE;
    private File DUMMY_DOC_FILE;
    private GraphReader graphReader;
    private InteractionsReader DUMMY_GRAPH_READER;
    private Collection dummyCollection;
    private List DUMMY_LIST;
    private CyFileFilter DUMMY_DOC_FILTER;
    private CyFileFilter DUMMY_SIF_FILTER;
    private CyFileFilter DUMMY_XML_FILTER;
    private CyFileFilter DUMMY_XLS_FILTER;
    private static String DUMMY_GRAPH_NATURE = "NETWORK";
    private static String DUMMY_NATURE = "xxxx";
    private ImportHandler importHandler;

    public void setUp() throws Exception {
        this.importHandler = new ImportHandler();
        this.DUMMY_DOC_FILTER = new CyFileFilter("doc", "Documents", "dummy");
        this.DUMMY_XLS_FILTER = new CyFileFilter("xls", "Excel", "dummy");
        this.DUMMY_SIF_FILTER = new CyFileFilter("sif", "Another Sif Filter", DUMMY_GRAPH_NATURE);
        this.DUMMY_XML_FILTER = new CyFileFilter("xml", "Another Xml Filter", DUMMY_GRAPH_NATURE);
        this.DUMMY_SIF_FILE = File.createTempFile("inputSifTest", ".sif");
        this.DUMMY_XGMML_FILE = File.createTempFile("inputXgmmlTest", ".xgmml");
        this.DUMMY_GML_FILE = File.createTempFile("inputGmlTest", ".gml");
        this.DUMMY_XML_FILE = File.createTempFile("inputXmlTest", ".xml");
        this.DUMMY_DOC_FILE = File.createTempFile("inputDocTest", ".doc");
        this.DUMMY_GRAPH_READER = new InteractionsReader(this.DUMMY_SIF_FILE.toString());
    }

    public void tearDown() throws Exception {
        this.importHandler = null;
        this.DUMMY_DOC_FILTER = null;
        this.DUMMY_XLS_FILTER = null;
        this.DUMMY_SIF_FILTER = null;
        this.DUMMY_XML_FILTER = null;
        this.DUMMY_SIF_FILE.delete();
        this.DUMMY_XGMML_FILE.delete();
        this.DUMMY_GML_FILE.delete();
        this.DUMMY_XML_FILE.delete();
        this.DUMMY_DOC_FILE.delete();
        this.graphReader = null;
    }

    public void testConstructor() {
        this.DUMMY_LIST = this.importHandler.getAllFilters();
        ImportHandlerTest.assertTrue(this.DUMMY_LIST != null);
        int value = this.DUMMY_LIST.size();
        ImportHandlerTest.assertEquals(5, value);
    }

    public void testGetAlls() {
        this.dummyCollection = this.importHandler.getAllTypes(ImportHandler.GRAPH_NATURE);
        ImportHandlerTest.assertTrue(this.dummyCollection != null);
        ImportHandlerTest.assertEquals(4, this.dummyCollection.size());
        boolean xgmmlFlag = false;
        for (String description : this.dummyCollection) {
            if (!description.equals("XGMML files")) continue;
            xgmmlFlag = true;
        }
        ImportHandlerTest.assertTrue(xgmmlFlag);
        this.dummyCollection = this.importHandler.getAllExtensions();
        ImportHandlerTest.assertTrue(this.dummyCollection != null);
        ImportHandlerTest.assertEquals(5, this.dummyCollection.size());
        boolean sifFlag = false;
        for (String fileExtension : this.dummyCollection) {
            if (!fileExtension.equals("sif")) continue;
            sifFlag = true;
        }
        ImportHandlerTest.assertTrue(sifFlag);
        this.dummyCollection = this.importHandler.getAllDescriptions();
        ImportHandlerTest.assertTrue(this.dummyCollection != null);
        ImportHandlerTest.assertEquals(4, this.dummyCollection.size());
        boolean gmlFlag = false;
        for (String description : this.dummyCollection) {
            if (!description.equals("GML files (*.gml)")) continue;
            gmlFlag = true;
        }
        ImportHandlerTest.assertTrue(gmlFlag);
        this.dummyCollection = this.importHandler.getAllTypes(DUMMY_NATURE);
        ImportHandlerTest.assertTrue(this.dummyCollection != null);
        ImportHandlerTest.assertEquals(0, this.dummyCollection.size());
        this.DUMMY_LIST = this.importHandler.getAllFilters(DUMMY_NATURE);
        ImportHandlerTest.assertTrue(this.dummyCollection != null);
        ImportHandlerTest.assertEquals(0, this.dummyCollection.size());
        this.dummyCollection = this.importHandler.getAllFilters();
        ImportHandlerTest.assertTrue(this.dummyCollection != null);
        ImportHandlerTest.assertEquals(5, this.dummyCollection.size());
        sifFlag = false;
        for (Object o : this.dummyCollection) {
            if (!(o instanceof SIFFileFilter)) continue;
            sifFlag = true;
        }
        ImportHandlerTest.assertTrue(sifFlag);
        this.DUMMY_LIST = this.importHandler.getAllFilters(DUMMY_GRAPH_NATURE);
        ImportHandlerTest.assertTrue(this.dummyCollection != null);
        ImportHandlerTest.assertEquals(5, this.dummyCollection.size());
        sifFlag = false;
        for (Object o : this.dummyCollection) {
            if (!(o instanceof SIFFileFilter)) continue;
            sifFlag = true;
        }
        ImportHandlerTest.assertTrue(sifFlag);
    }

    public void testAddFilter() {
        this.importHandler.resetImportHandler();
        boolean success = this.importHandler.addFilter(this.DUMMY_SIF_FILTER);
        ImportHandlerTest.assertEquals(false, success);
        success = this.importHandler.addFilter(this.DUMMY_DOC_FILTER);
        ImportHandlerTest.assertEquals(true, success);
        this.DUMMY_LIST = this.importHandler.getAllFilters();
        ImportHandlerTest.assertEquals(6, this.DUMMY_LIST.size());
    }

    public void testAddFilters() {
        CyFileFilter[] cff1 = new CyFileFilter[]{this.DUMMY_SIF_FILTER, this.DUMMY_XML_FILTER};
        CyFileFilter[] cff2 = new CyFileFilter[]{this.DUMMY_DOC_FILTER, this.DUMMY_XLS_FILTER};
        this.importHandler.resetImportHandler();
        this.DUMMY_LIST = this.importHandler.getAllFilters();
        ImportHandlerTest.assertEquals(5, this.DUMMY_LIST.size());
        boolean success = this.importHandler.addFilter(cff1);
        ImportHandlerTest.assertEquals(false, success);
        this.DUMMY_LIST = this.importHandler.getAllFilters();
        ImportHandlerTest.assertEquals(5, this.DUMMY_LIST.size());
        success = this.importHandler.addFilter(cff2);
        ImportHandlerTest.assertEquals(true, success);
        this.DUMMY_LIST = this.importHandler.getAllFilters();
        ImportHandlerTest.assertEquals(7, this.DUMMY_LIST.size());
    }

    public void testGetFileAttributes() {
        String value = this.importHandler.getFileType(this.DUMMY_SIF_FILE.toString());
        ImportHandlerTest.assertEquals("SIF files", value);
        Collection extensions = this.importHandler.getAllExtensions();
        boolean exists = extensions.contains("sif");
        ImportHandlerTest.assertEquals(true, exists);
        this.graphReader = this.importHandler.getReader(DUMMY_GRAPH_NATURE);
        ImportHandlerTest.assertEquals(null, this.graphReader);
        this.graphReader = this.importHandler.getReader(this.DUMMY_SIF_FILE.toString());
        exists = this.graphReader == null;
        ImportHandlerTest.assertFalse(exists);
    }

    public static void main(String[] args) {
        TestRunner.run(ImportHandlerTest.class);
    }
}

