/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.readers.GraphReader;
import cytoscape.logger.CyLogger;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTask;
import cytoscape.util.CyFileFilter;
import cytoscape.util.GMLFileFilter;
import cytoscape.util.NNFFileFilter;
import cytoscape.util.ProxyHandler;
import cytoscape.util.SIFFileFilter;
import cytoscape.util.XGMMLFileFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportHandler {
    public static String GRAPH_NATURE = "NETWORK";
    public static String NODE_NATURE = "NODE";
    public static String EDGE_NATURE = "EDGE";
    public static String PROPERTIES_NATURE = "PROPERTIES";
    protected static Set<CyFileFilter> cyFileFilters = new HashSet<CyFileFilter>();

    public ImportHandler() {
        this.init();
    }

    private void init() {
        this.addFilter(new SIFFileFilter());
        this.addFilter(new XGMMLFileFilter());
        this.addFilter(new GMLFileFilter());
        this.addFilter(new NNFFileFilter());
    }

    public boolean addFilter(CyFileFilter cff) {
        Set<String> check = cff.getExtensionSet();
        for (String extension : check) {
            if (!this.getAllExtensions().contains(extension) || extension.equals("xml")) continue;
            return false;
        }
        cyFileFilters.add(cff);
        return true;
    }

    public boolean addFilter(CyFileFilter[] cff) {
        boolean flag = true;
        for (int j = 0; j < cff.length && flag; ++j) {
            flag = this.addFilter(cff[j]);
        }
        return flag;
    }

    public GraphReader getReader(String fileName) {
        for (CyFileFilter cff : cyFileFilters) {
            if (!cff.accept(fileName)) continue;
            return cff.getReader(fileName);
        }
        return null;
    }

    public GraphReader getReader(URL url) {
        int cend;
        Proxy pProxyServer = ProxyHandler.getProxyServer();
        URLConnection conn = null;
        try {
            conn = pProxyServer == null ? url.openConnection() : url.openConnection(pProxyServer);
        }
        catch (IOException ioe) {
            CyLogger.getLogger().error("Unable to open " + url + ": " + ioe.getMessage(), ioe);
            return null;
        }
        conn.setUseCaches(false);
        String contentType = conn.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if ((cend = contentType.indexOf(59)) >= 0) {
            contentType = contentType.substring(0, cend);
        }
        for (CyFileFilter cff : cyFileFilters) {
            GraphReader reader;
            boolean accept = cff.accept(url, contentType);
            if (!accept || (reader = cff.getReader(url, conn)) == null) continue;
            return reader;
        }
        if (contentType.contains("text/html") || contentType.contains("text/plain") || contentType.contains("text/xml") || contentType.contains("application/rdf+xml")) {
            File tmpFile = null;
            try {
                tmpFile = this.downloadFromURL(url, null);
            }
            catch (Exception e) {
                CyLogger.getLogger().error("Failed to download from URL: " + url, e);
            }
            if (tmpFile != null) {
                return this.getReader(tmpFile.getAbsolutePath());
            }
        }
        return null;
    }

    public Collection getAllTypes(String fileNature) {
        HashSet<String> ans = new HashSet<String>();
        for (CyFileFilter cff : cyFileFilters) {
            if (!cff.getFileNature().equals(fileNature)) continue;
            cff.setExtensionListInDescription(false);
            ans.add(cff.getDescription());
            cff.setExtensionListInDescription(true);
        }
        return ans;
    }

    public Collection getAllExtensions() {
        HashSet<String> ans = new HashSet<String>();
        Iterator<CyFileFilter> it = cyFileFilters.iterator();
        while (it.hasNext()) {
            ans.addAll(it.next().getExtensionSet());
        }
        return ans;
    }

    public Collection getAllDescriptions() {
        HashSet<String> ans = new HashSet<String>();
        Iterator<CyFileFilter> it = cyFileFilters.iterator();
        while (it.hasNext()) {
            ans.add(it.next().getDescription());
        }
        return ans;
    }

    public String getFileType(String fileName) {
        String ans = null;
        for (CyFileFilter cff : cyFileFilters) {
            if (!cff.accept(fileName)) continue;
            cff.setExtensionListInDescription(false);
            ans = cff.getDescription();
            cff.setExtensionListInDescription(true);
        }
        return ans;
    }

    public List getAllFilters() {
        ArrayList<CyFileFilter> ans = new ArrayList<CyFileFilter>();
        Iterator<CyFileFilter> it = cyFileFilters.iterator();
        while (it.hasNext()) {
            ans.add(it.next());
        }
        if (ans.size() > 1) {
            String[] allTypes = this.concatAllExtensions(ans);
            ans.add(new CyFileFilter(allTypes, "All Natures"));
        }
        return ans;
    }

    public List getAllFilters(String fileNature) {
        ArrayList<CyFileFilter> ans = new ArrayList<CyFileFilter>();
        for (CyFileFilter cff : cyFileFilters) {
            if (!cff.getFileNature().equals(fileNature)) continue;
            ans.add(cff);
        }
        if (ans.size() > 1) {
            String[] allTypes = this.concatAllExtensions(ans);
            ans.add(new CyFileFilter(allTypes, "All " + fileNature.toLowerCase() + " files", fileNature));
        }
        return ans;
    }

    public void resetImportHandler() {
        cyFileFilters = new HashSet<CyFileFilter>();
        this.init();
    }

    private String[] concatAllExtensions(List cffs) {
        HashSet<String> ans = new HashSet<String>();
        Iterator it = cffs.iterator();
        while (it.hasNext()) {
            ans.addAll(((CyFileFilter)it.next()).getExtensionSet());
        }
        String[] stringAns = ans.toArray(new String[0]);
        return stringAns;
    }

    private String extractExtensionFromContentType(String ct) {
        Pattern p = Pattern.compile("^\\w+/([\\w|-]+);*.*");
        Matcher m = p.matcher(ct);
        if (m.matches()) {
            return m.group(1);
        }
        return "txt";
    }

    private File createTempFile(URLConnection conn, URL url) throws IOException {
        File tmpFile = null;
        String tmpDir = System.getProperty("java.io.tmpdir");
        String pURLstr = url.toString();
        Collection theExts = this.getAllExtensions();
        for (String theExt : theExts) {
            if (!pURLstr.endsWith(theExt)) continue;
            tmpFile = new File(tmpDir + System.getProperty("file.separator") + pURLstr.substring(pURLstr.lastIndexOf("/") + 1));
            break;
        }
        if (tmpFile == null) {
            String ct = "." + this.extractExtensionFromContentType(conn.getContentType());
            tmpFile = File.createTempFile("url.download.", ct, new File(tmpDir));
        }
        if (tmpFile == null) {
            return null;
        }
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadFromURL(URL url, TaskMonitor taskMonitor) throws IOException, FileNotFoundException {
        Proxy pProxyServer = ProxyHandler.getProxyServer();
        URLConnection conn = null;
        conn = pProxyServer == null ? url.openConnection() : url.openConnection(pProxyServer);
        conn.setUseCaches(false);
        File tmpFile = this.createTempFile(conn, url);
        int maxCount = conn.getContentLength();
        int progressCount = 0;
        BufferedWriter out = null;
        BufferedReader in = null;
        out = new BufferedWriter(new FileWriter(tmpFile));
        try {
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            try {
                String inputLine = null;
                double percent = 0.0;
                while ((inputLine = in.readLine()) != null) {
                    progressCount += inputLine.length();
                    if (taskMonitor != null) {
                        JTask jTask;
                        percent = (double)progressCount / (double)maxCount * 100.0;
                        if (maxCount == -1) {
                            percent = -1.0;
                        }
                        if ((jTask = (JTask)taskMonitor).haltRequested()) {
                            tmpFile = null;
                            taskMonitor.setStatus("Canceling the download task ...");
                            taskMonitor.setPercentCompleted(100);
                            break;
                        }
                        taskMonitor.setPercentCompleted((int)percent);
                    }
                    out.write(inputLine);
                    out.newLine();
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return tmpFile;
    }
}

