/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.cruft.obo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public final class OboOntologyReader
extends Reader {
    private final String NL = System.getProperty("line.separator");
    private BufferedReader m_obo;
    private String m_readString;
    private int m_readInx;

    public OboOntologyReader(Reader oboFile) {
        if (oboFile == null) {
            throw new NullPointerException("oboFile is null");
        }
        this.m_obo = new BufferedReader(oboFile);
        this.m_readString = "(curator=GO) (type=all)" + this.NL;
        this.m_readInx = 0;
    }

    public final int read(char[] cbuf, int off, int len) throws IOException {
        int returnThis;
        if (this.m_obo == null) {
            throw new IOException("this stream is closed");
        }
        if (this.m_readString == null) {
            return -1;
        }
        if (this.m_readString.length() - this.m_readInx >= len) {
            this.m_readString.getChars(this.m_readInx, this.m_readInx + len, cbuf, off);
            returnThis = len;
            this.m_readInx += len;
        } else {
            this.m_readString.getChars(this.m_readInx, this.m_readString.length(), cbuf, off);
            returnThis = this.m_readString.length() - this.m_readInx;
            this.m_readInx = this.m_readString.length();
        }
        if (this.m_readInx == this.m_readString.length()) {
            this.readMore();
        }
        return returnThis;
    }

    private final void readMore() throws IOException {
        String line;
        String line2;
        String trimmedLine;
        do {
            if ((line2 = this.m_obo.readLine()) != null) continue;
            this.m_readString = null;
            return;
        } while (!(trimmedLine = line2.trim()).equals("[Term]"));
        String id = "";
        String desc = "";
        String isa = "";
        String partof = "";
        while ((line = this.m_obo.readLine().trim()).length() != 0) {
            int colonInx = line.indexOf(58);
            String key = line.substring(0, colonInx).trim();
            String val = line.substring(colonInx + 1).trim();
            if (key.equals("id")) {
                id = val.substring(3);
                continue;
            }
            if (key.equals("name")) {
                desc = val;
                continue;
            }
            if (key.equals("is_a")) {
                String isaElement = val.substring(3, 10);
                isa = isa + isaElement + " ";
                continue;
            }
            if (!key.equals("relationship") || !val.startsWith("part_of")) continue;
            String partofElement = val.substring(11, 18);
            partof = partof + partofElement + " ";
        }
        this.m_readString = id + " = " + desc;
        if (isa.length() > 0) {
            this.m_readString = this.m_readString + " [isa: " + isa + "]";
        }
        if (partof.length() > 0) {
            this.m_readString = this.m_readString + " [partof: " + partof + "]";
        }
        this.m_readString = this.m_readString + this.NL;
        this.m_readInx = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        try {
            this.m_obo.close();
        }
        finally {
            this.m_obo = null;
        }
    }
}

