/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.cruft.obo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;

public final class BiologicalProcessAnnotationReader
extends Reader {
    private final String NL = System.getProperty("line.separator");
    private BufferedReader m_file;
    private String m_readString;
    private int m_readInx;
    private Map ontologyTypeMap;

    public BiologicalProcessAnnotationReader(String speciesName, Reader geneAssociationFile) {
        if (geneAssociationFile == null) {
            throw new NullPointerException("geneAssociationFile is null");
        }
        this.m_file = new BufferedReader(geneAssociationFile);
        this.m_readString = "(species=" + speciesName + ") (type=Biological Process) (curator=GO)" + this.NL;
        this.m_readInx = 0;
    }

    public BiologicalProcessAnnotationReader(String speciesName, Map ontologyTypeMap, Reader geneAssociationFile) {
        if (geneAssociationFile == null) {
            throw new NullPointerException("geneAssociationFile is null");
        }
        this.ontologyTypeMap = ontologyTypeMap;
        this.m_file = new BufferedReader(geneAssociationFile);
        this.m_readString = "(species=" + speciesName + ") (type=Biological Process) (curator=GO)" + this.NL;
        this.m_readInx = 0;
    }

    public final int read(char[] cbuf, int off, int len) throws IOException {
        int returnThis;
        if (this.m_file == null) {
            throw new IOException("this stream is closed");
        }
        if (this.m_readString == null) {
            return -1;
        }
        if (this.m_readString.length() - this.m_readInx >= len) {
            this.m_readString.getChars(this.m_readInx, this.m_readInx + len, cbuf, off);
            returnThis = len;
            this.m_readInx += len;
        } else {
            this.m_readString.getChars(this.m_readInx, this.m_readString.length(), cbuf, off);
            returnThis = this.m_readString.length() - this.m_readInx;
            this.m_readInx = this.m_readString.length();
        }
        if (this.m_readInx == this.m_readString.length()) {
            this.readMore();
        }
        return returnThis;
    }

    private final void readMore() throws IOException {
        String goid;
        String canon;
        while (true) {
            String line;
            if ((line = this.m_file.readLine()) == null) {
                this.m_readString = null;
                return;
            }
            if ((line = line.trim()).length() <= 0 || line.startsWith("!")) continue;
            int fromIndex = 0;
            for (int i = 0; i < 2; ++i) {
                fromIndex = 1 + line.indexOf(9, fromIndex);
            }
            canon = line.substring(fromIndex, line.indexOf(9, fromIndex));
            for (int i = 0; i < 2; ++i) {
                fromIndex = 1 + line.indexOf(9, fromIndex);
            }
            goid = line.substring(fromIndex + 3, fromIndex + 10);
            for (int i = 0; i < 4; ++i) {
                fromIndex = 1 + line.indexOf(9, fromIndex);
            }
            String type = line.substring(fromIndex, fromIndex + 1);
            if (!(type.equals("P") || type.equals("C") || type.equals("F"))) {
                type = (String)this.ontologyTypeMap.get("GO:" + goid);
            }
            if (type != null && type.equals("P")) break;
        }
        this.m_readString = canon + " = " + goid + this.NL;
        this.m_readInx = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        try {
            this.m_file.close();
        }
        finally {
            this.m_file = null;
        }
    }
}

