/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.actions.OpenSessionTask;
import cytoscape.logger.CyLogger;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.CyFileFilter;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.FileUtil;
import cytoscape.view.CyMenus;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class OpenSessionAction
extends CytoscapeAction {
    protected CyMenus windowMenu;
    protected static CyLogger logger = CyLogger.getLogger(OpenSessionAction.class);
    public static final String SESSION_EXT = "cys";

    public OpenSessionAction() {
        super("Open");
        this.setPreferredMenu("File");
        this.setAcceleratorCombo(79, 2);
        this.windowMenu = null;
    }

    public OpenSessionAction(CyMenus windowMenu, boolean label) {
        this.windowMenu = windowMenu;
    }

    public void actionPerformed(ActionEvent e) {
        boolean proceed = this.prepare();
        if (proceed) {
            String name;
            CyFileFilter sessionFilter = new CyFileFilter();
            sessionFilter.addExtension(SESSION_EXT);
            sessionFilter.setDescription("Cytoscape Session files");
            try {
                name = FileUtil.getFile("Open a Session File", FileUtil.LOAD, new CyFileFilter[]{sessionFilter}).toString();
            }
            catch (Exception exp) {
                return;
            }
            Cytoscape.setSessionState(Cytoscape.SESSION_OPENED);
            Cytoscape.createNewSession();
            Cytoscape.setSessionState(Cytoscape.SESSION_NEW);
            logger.info("Opening session file: " + name);
            OpenSessionTask task = new OpenSessionTask(name);
            JTaskConfig jTaskConfig = new JTaskConfig();
            jTaskConfig.setOwner(Cytoscape.getDesktop());
            jTaskConfig.displayCloseButton(true);
            jTaskConfig.displayCancelButton(false);
            jTaskConfig.displayStatus(true);
            jTaskConfig.setAutoDispose(false);
            TaskManager.executeTask(task, jTaskConfig);
        }
    }

    private boolean prepare() {
        int currentNetworkCount = Cytoscape.getNetworkSet().size();
        if (currentNetworkCount != 0) {
            String warning = "Current session will be lost.\nDo you want to continue?";
            int result = JOptionPane.showConfirmDialog(Cytoscape.getDesktop(), "Current session will be lost.\nDo you want to continue?", "Caution!", 0, 2, null);
            return result == 0;
        }
        return true;
    }
}

