/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Position;
import com.sun.glf.TextAlignment;
import com.sun.glf.TextLayer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

class FontPreview
extends JComponent {
    Font font;
    Font displayFont;
    RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    static final Font defaultFont = new Font("Dialog", 0, 12);
    static final String string = "The quick brown fox";
    static final int displayFontSize = 20;
    BufferedImage buffer;
    Graphics2D g;
    boolean fixedSize;

    public FontPreview(Font font, boolean bl) {
        this.fixedSize = bl;
        this.setPreferredSize(new Dimension(200, 30));
        this.setFont(font);
    }

    public void setFont(Font font) {
        Font font2 = this.font;
        this.font = font == null ? defaultFont : font;
        this.displayFont = this.fixedSize ? new Font(this.font.getName(), this.font.getStyle(), 20) : this.font;
        if (!this.font.equals(font2)) {
            this.prepareBuffer();
        }
        String string = this.font.getFontName() + " " + this.font.getSize();
        if (this.font.isBold()) {
            string = string + " Bold";
        }
        if (this.font.isItalic()) {
            string = string + " Italic";
        }
        this.setToolTipText(string);
    }

    private void prepareBuffer() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension.width <= 0) {
            dimension.width = dimension2.width;
        }
        if (dimension.height <= 0) {
            dimension.height = dimension2.height;
        }
        if (this.buffer == null || dimension.width != this.buffer.getWidth() || dimension.height != this.buffer.getHeight()) {
            this.buffer = new BufferedImage(dimension.width, dimension.height, 2);
            this.g = this.buffer.createGraphics();
        }
        this.g.setTransform(new AffineTransform());
        this.g.setComposite(AlphaComposite.Clear);
        this.g.fillRect(0, 0, dimension.width, dimension.height);
        this.g.setComposite(AlphaComposite.SrcOver);
        LayerComposition layerComposition = new LayerComposition(this.getSize());
        FillRenderer fillRenderer = new FillRenderer(this.getForeground() != null ? this.getForeground() : Color.black);
        TextLayer textLayer = new TextLayer(layerComposition, string, this.displayFont, fillRenderer, Position.LEFT, 2.1474836E9f, TextAlignment.CENTER);
        layerComposition.setLayers(new Layer[]{textLayer});
        layerComposition.setRenderingHints(this.rh);
        layerComposition.paint(this.g);
        this.repaint();
    }

    public Font getFont() {
        return this.font;
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.prepareBuffer();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.buffer == null || dimension.width != this.buffer.getWidth() || dimension.height != this.buffer.getHeight()) {
            this.prepareBuffer();
        }
        graphics.drawImage(this.buffer, 0, 0, null);
    }
}

