/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.stack;

import com.sosnoski.util.ArrayRangeIterator;
import com.sosnoski.util.stack.StackBase;
import java.util.Iterator;

public class StringStack
extends StackBase {
    protected String[] m_baseArray;
    static /* synthetic */ Class class$java$lang$String;

    public StringStack(int n, int n2) {
        super(n, n2, class$java$lang$String == null ? (class$java$lang$String = StringStack.class$("java.lang.String")) : class$java$lang$String);
    }

    public StringStack(int n) {
        super(n, class$java$lang$String == null ? (class$java$lang$String = StringStack.class$("java.lang.String")) : class$java$lang$String);
    }

    public StringStack() {
        this(8);
    }

    public StringStack(StringStack stringStack) {
        super(stringStack);
    }

    protected Object getArray() {
        return this.m_baseArray;
    }

    protected void setArray(Object object) {
        this.m_baseArray = (String[])object;
    }

    public void push(String string) {
        int n = this.getAddIndex();
        this.m_baseArray[n] = string;
    }

    public String pop() {
        if (this.m_countPresent > 0) {
            String string = this.m_baseArray[--this.m_countPresent];
            this.m_baseArray[this.m_countPresent] = null;
            return string;
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop empty stack");
    }

    public String pop(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        if (this.m_countPresent >= n) {
            this.m_countPresent -= n;
            String string = this.m_baseArray[this.m_countPresent];
            this.discardValues(this.m_countPresent, this.m_countPresent + n);
            return string;
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop past end of stack");
    }

    public String peek(int n) {
        if (this.m_countPresent > n) {
            return this.m_baseArray[this.m_countPresent - n - 1];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to peek past end of stack");
    }

    public String peek() {
        return this.peek(0);
    }

    public final Iterator iterator() {
        return ArrayRangeIterator.buildIterator(this.m_baseArray, 0, this.m_countPresent);
    }

    public String[] toArray() {
        return (String[])this.buildArray(class$java$lang$String == null ? (class$java$lang$String = StringStack.class$("java.lang.String")) : class$java$lang$String);
    }

    public Object clone() {
        return new StringStack(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

