/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.array;

import com.sosnoski.util.array.ArrayBase;

public class ByteArray
extends ArrayBase {
    protected byte[] m_baseArray;

    public ByteArray(int n, int n2) {
        super(n, n2, Byte.TYPE);
    }

    public ByteArray(int n) {
        super(n, Byte.TYPE);
    }

    public ByteArray() {
        this(8);
    }

    public ByteArray(ByteArray byteArray) {
        super(byteArray);
    }

    protected final Object getArray() {
        return this.m_baseArray;
    }

    protected final void setArray(Object object) {
        this.m_baseArray = (byte[])object;
    }

    public final int add(int n) {
        int n2 = this.getAddIndex();
        this.m_baseArray[n2] = (byte)n;
        return n2;
    }

    public void add(int n, int n2) {
        this.makeInsertSpace(n);
        this.m_baseArray[n] = (byte)n2;
    }

    public final byte get(int n) {
        if (n < this.m_countPresent) {
            return this.m_baseArray[n];
        }
        throw new ArrayIndexOutOfBoundsException("Invalid index value");
    }

    public final void set(int n, int n2) {
        if (n >= this.m_countPresent) {
            throw new ArrayIndexOutOfBoundsException("Invalid index value");
        }
        this.m_baseArray[n] = (byte)n2;
    }

    public byte[] toArray() {
        return (byte[])this.buildArray(Byte.TYPE, 0, this.m_countPresent);
    }

    public byte[] toArray(int n, int n2) {
        return (byte[])this.buildArray(Byte.TYPE, n, n2);
    }

    public Object clone() {
        return new ByteArray(this);
    }
}

