/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import LZMA.LzmaInputStream;
import com.install4j.api.ApplicationRegistry;
import com.install4j.api.SystemInfo;
import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileInfo;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.MacLauncher;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.ContentCollector;
import com.install4j.runtime.installer.helper.content.ContentStats;
import com.install4j.runtime.installer.helper.content.JreInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ContentInstaller {
    private FileInstaller fileInstaller = FileInstaller.getInstance();
    private JreInstaller jreInstaller = new JreInstaller();
    private static ContentInstaller instance = new ContentInstaller();
    public static final long FILE_WEIGHT = 153600L;

    public static ContentInstaller getInstance() {
        return instance;
    }

    private ContentInstaller() {
    }

    public void doStandardInstallation(InstallerContext installerContext, ProgressInterface progressInterface, InstallFilesAction installFilesAction) throws IOException, UserCanceledException {
        if (installerContext.isCancelling()) {
            return;
        }
        this.fileInstaller.createDirectory(installerContext.getInstallationDirectory());
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        ContentStats contentStats = ContentStats.getInstance();
        long l = contentStats.getSelectedContentSize();
        long l2 = contentStats.getSelectedContentCount();
        boolean bl = this.jreInstaller.checkJreInstallation(installerContext.getInstallationDirectory());
        if (bl) {
            l += this.jreInstaller.getJreSize();
            l2 += (long)this.jreInstaller.getJreCount();
        }
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        l += 153600L * l2;
        long l3 = 0L;
        Map map = new ContentCollector(progressInterface, installerContext).collectContentStreams();
        progressInterface.setStatusMessage(Messages.getMessages().getString("StatusExtractFiles"));
        progressInterface.setDetailMessage("");
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            InputStream inputStream = (InputStream)iterator.next();
            l3 = this.installContent(installerContext, inputStream, progressInterface, installFilesAction, 153600L, l, l3);
        }
        if (bl) {
            this.jreInstaller.installJre(installerContext, progressInterface, 153600L, l, l3);
        }
        this.jreInstaller.writePreferredJre(installerContext.getDestinationFile(".install4j"));
        progressInterface.setDetailMessage("");
        this.createRuntimeDirectory(installerContext);
        if (!installerContext.isCancelling()) {
            progressInterface.setPercentCompleted(100);
        }
    }

    private long installContent(InstallerContext installerContext, InputStream inputStream, ProgressInterface progressInterface, InstallFilesAction installFilesAction, long l, long l2, long l3) throws IOException, UserCanceledException {
        inputStream = new BufferedInputStream(inputStream);
        if (InstallerConfig.getCurrentInstance().isLzmaCompression()) {
            inputStream = new LzmaInputStream(inputStream);
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            FileOptions fileOptions;
            Object object;
            if (installerContext.isCancelling()) {
                throw new UserCanceledException();
            }
            String string = zipEntry.getName();
            string = InstallerUtil.isWindows() ? string.replace('/', '\\') : string.replace('\\', '/');
            FileInfo fileInfo = installerContext.getDestinationFileInfo(string);
            progressInterface.setDetailMessage(InstallerUtil.cleanupName(fileInfo.getRelativeFilePath()));
            boolean bl = true;
            File file = fileInfo.getRootResolved();
            if (file != null) {
                if (fileInfo.getRootUnresolved() != null && fileInfo.getRelativeFilePath().equals("\\") || fileInfo.getRelativeFilePath().equals("/") || fileInfo.getRelativeFilePath().equals("")) {
                    bl = false;
                } else {
                    Object object2;
                    object = installFilesAction.getFileFilterScript();
                    if (object != null) {
                        try {
                            object2 = (Boolean)installerContext.runScript((ScriptProperty)object, installFilesAction, new Object[]{fileInfo});
                            bl = object2 == null || ((Boolean)object2).booleanValue();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Logger.getInstance().log(exception);
                            bl = false;
                        }
                    }
                    object2 = installFilesAction.getDirectoryResolverScript();
                    if (bl && object2 != null) {
                        try {
                            File file2 = (File)installerContext.runScript((ScriptProperty)object2, installFilesAction, new Object[]{fileInfo});
                            if (file2 != null) {
                                file = file2;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Logger.getInstance().log(exception);
                            bl = false;
                        }
                    }
                }
            }
            if (file == null) {
                bl = false;
            }
            object = InstallerConfig.getCurrentInstance();
            long l4 = l3 + l;
            File file3 = this.getDestFile(file, fileInfo.getRelativeFilePath());
            if (zipEntry.isDirectory()) {
                if (bl) {
                    fileOptions = ((InstallerConfig)object).getOptions(string);
                    UninstallMode uninstallMode = UninstallMode.IF_CREATED;
                    if (fileOptions != null) {
                        uninstallMode = fileOptions.getUninstallMode();
                    }
                    this.fileInstaller.createDirectory(file3, uninstallMode);
                    file3.setLastModified(zipEntry.getTime());
                    if (fileOptions != null && !InstallerUtil.isWindows()) {
                        UnixFileSystem.setMode(fileOptions.getMode(), file3);
                    }
                }
            } else {
                l4 += zipEntry.getSize();
                if (bl) {
                    fileOptions = ((InstallerConfig)object).getOptions(string);
                    if (fileOptions == null) {
                        fileOptions = new FileOptions();
                    }
                    fileOptions.setFileTime(zipEntry.getTime());
                    this.fileInstaller.install(zipInputStream, file3, fileOptions, new ProgressAdapter(progressInterface, (int)(l3 * 100L / l2), (int)(l4 * 100L / l2)), zipEntry.getSize(), ((InstallerConfig)object).isPack200Compression());
                }
            }
            if (installerContext.isCancelling()) {
                throw new UserCanceledException();
            }
            l3 = l4;
            progressInterface.setPercentCompleted((int)(l3 * 100L / l2));
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        return l3;
    }

    private File getDestFile(File file, String string) {
        if (Util.isMacosInstaller() && string.startsWith("uninstall.app")) {
            string = this.getUninstallerName() + string.substring("uninstall".length());
        }
        return new File(file, string);
    }

    private String getUninstallerName() {
        String string = ContentInstaller.replaceSlashes(InstallerConfig.getCurrentInstance().getApplicationName());
        return MessageFormat.format(Messages.getMessages().getString("UninstallerMenuEntry"), string);
    }

    private static String replaceSlashes(String string) {
        return string.replace('/', ' ').replace('\\', ' ').replace(':', ' ').replace(';', ' ');
    }

    private void createRuntimeDirectory(Context context) throws IOException, UserCanceledException {
        FileOptions fileOptions = new FileOptions(OverwriteMode.ALWAYS, UninstallMode.ALWAYS);
        File file = new File(System.getProperty("user.dir"));
        File file2 = InstallerUtil.isMacOS() && !InstallerUtil.DEBUG && MacLauncher.isUsed() ? new File(".install4j") : file;
        File file3 = new File(file2, "i4jruntime.jar");
        File file4 = context.getDestinationFile(".install4j");
        File file5 = new File(file4, "i4jruntime.jar");
        this.fileInstaller.createDirectory(file4, UninstallMode.ALWAYS);
        this.fileInstaller.install(file3, file5, fileOptions);
        if (InstallerConfig.getCurrentInstance().getInstallerType() == 1) {
            this.fileInstaller.install(new File(file, "MessagesDefault"), new File(file4, "MessagesDefault"), fileOptions);
            this.fileInstaller.install(new File(file, "i4jparams.conf"), new File(file4, "i4jparams.conf"), fileOptions);
            this.installIfExists("user.jar", file, file4, fileOptions);
            this.installIfExists("installerHeader.png", file, file4, fileOptions);
            this.installIfExists("uninstallerHeader.png", file, file4, fileOptions);
            this.installIfExists("installer16.png", file, file4, fileOptions);
            this.installIfExists("installer32.png", file, file4, fileOptions);
        }
        File[] fileArray = new File(System.getProperty("user.dir")).listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file6 = fileArray[i];
            String string = file6.getName().toLowerCase();
            if (!string.endsWith(".dll") && !string.endsWith(".exe") && !string.startsWith("i4j_extf_")) continue;
            this.fileInstaller.install(file6, new File(file4, file6.getName()), fileOptions);
        }
    }

    private void installIfExists(String string, File file, File file2, FileOptions fileOptions) throws UserCanceledException {
        File file3 = new File(file, string);
        if (file3.exists()) {
            this.fileInstaller.install(file3, new File(file2, string), fileOptions);
        }
    }

    public void setPreferredJre(String string) {
        this.jreInstaller.setPreferredJre(string);
    }

    public long getMinSize() {
        try {
            return this.jreInstaller.getJreSize() + ContentStats.getInstance().getSelectedContentSize();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0L;
        }
    }

    public static File validateInstallationDir(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        boolean bl6;
        boolean bl7;
        ResourceBundle resourceBundle = Messages.getMessages();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        boolean bl8 = bl7 = !Util.isMacosInstaller() || !installerConfig.getMacSpecificConfig().isSingleBundle();
        if (bl7 && !ApplicationRegistry.checkApplicationId(file)) {
            File file2;
            if (bl) {
                if (installerConfig.getInstallerType() == 1) {
                    GUIHelper.showMessage(Util.getParentWindow(), resourceBundle.getString(bl5 ? "DifferentApplication2" : "DifferentApplication"), 1);
                } else {
                    File file3;
                    if (Util.isMacosInstaller() && ApplicationRegistry.checkApplicationId(file3 = new File(file, "Contents/Resources/app"))) {
                        return file3;
                    }
                    GUIHelper.showMessage(Util.getParentWindow(), resourceBundle.getString(bl5 ? "NoTargetApplication2" : "NoTargetApplication"), 1);
                }
                return null;
            }
            if (Util.isMacosInstaller() && installerConfig.getInstallerType() == 2 && ApplicationRegistry.checkApplicationId(file2 = new File(file, "Contents/Resources/app"))) {
                return file2;
            }
        }
        if (!(bl6 = ApplicationRegistry.isUpdateDirectory(file)) && bl2) {
            long l = (long)((double)ContentInstaller.getInstance().getMinSize() * 1.1);
            long l2 = SystemInfo.getFreeDiskSpace(file);
            if (l2 != -1L && l > l2) {
                try {
                    if (InstallerUtil.isUnattended()) {
                        System.err.println("Not enough disk space for target directory: " + file.getAbsolutePath());
                        return null;
                    }
                    int n = GUIHelper.showOptionDialog(Util.getParentWindow(), MessageFormat.format(resourceBundle.getString("DiskSpaceWarning"), String.valueOf(l / 1024L), String.valueOf(l2 / 1024L)), new String[]{resourceBundle.getString("ButtonYes"), resourceBundle.getString("ButtonNo")}, 3);
                    if (n == 1) {
                        return null;
                    }
                }
                catch (UserCanceledException userCanceledException) {
                    return null;
                }
            }
        }
        if (installerConfig.getInstallerType() == 1 && bl3 && file.exists() && !bl6 && !bl4 && bl7) {
            try {
                int n = GUIHelper.showOptionDialog(Util.getParentWindow(), MessageFormat.format(resourceBundle.getString("DirExists"), file.getAbsolutePath()), new String[]{resourceBundle.getString("ButtonYes"), resourceBundle.getString("ButtonNo")}, 3);
                if (n == 1) {
                    return null;
                }
            }
            catch (UserCanceledException userCanceledException) {
                return null;
            }
        }
        return file;
    }
}

