/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.services;

import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.SudoExecution;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;

public class InstallServiceAction
extends SystemAutoUninstallInstallAction {
    private String launcherId = "";
    private boolean addToScreen = true;
    private boolean allowUserChangeStartType = true;
    private boolean selected = true;
    private static final String PROP_SERVICE_PATH = "servicePath";
    private static final String PROP_SERVICE_NAME = "serviceName";
    private static final String PROP_STARTUP_TYPE = "startupType";
    private static final String STARTUP_ITEMS_FILE_NAME = "/Library/StartupItems";
    private static final String STARTUP_PARAMETERS_PLIST_NAME = "StartupParameters.plist";
    public static final String VARIABLE_SELECTED_PREFIX = "sys.service.selected.";
    public static final String VARIABLE_STARTUP_TYPE_PREFIX = "sys.service.startupType.";

    public void init(Context context) {
        final ServiceConfig serviceConfig = InstallerConfig.getCurrentInstance().getServiceConfigById(this.getLauncherId());
        if (serviceConfig != null) {
            String string = VARIABLE_SELECTED_PREFIX + this.getLauncherId();
            Object object = InstallerVariables.getVariable(string);
            if (object != null && object instanceof Boolean) {
                this.setSelected((Boolean)object);
            }
            InstallerVariables.registerResponseFileVariable(string);
            InstallerVariables.registerVariableProvider(string, new InstallerVariables.VariableProvider(){

                public Object getVariable() {
                    return InstallServiceAction.this.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                }

                public void setVariable(Object object) {
                    if (object != null && object instanceof Boolean) {
                        InstallServiceAction.this.setSelected((Boolean)object);
                    }
                }
            });
            string = VARIABLE_STARTUP_TYPE_PREFIX + this.getLauncherId();
            object = InstallerVariables.getVariable(string);
            if (object != null && object instanceof String) {
                serviceConfig.setStartupType((String)object);
            }
            InstallerVariables.registerResponseFileVariable(string);
            InstallerVariables.registerVariableProvider(string, new InstallerVariables.VariableProvider(){

                public Object getVariable() {
                    return serviceConfig.getStartupType();
                }

                public void setVariable(Object object) {
                    if (object != null && object instanceof String) {
                        serviceConfig.setStartupType((String)object);
                    }
                }
            });
        }
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        if (!this.isSelected()) {
            return true;
        }
        ProgressInterface progressInterface = installerContext.getProgressInterface();
        progressInterface.setDetailMessage("");
        LauncherSetup launcherSetup = installerContext.getLauncherById(this.getLauncherId());
        if (launcherSetup == null) {
            return false;
        }
        File file = installerContext.getDestinationFile(launcherSetup.getRelativeFileName());
        if (!file.exists()) {
            return false;
        }
        ServiceConfig serviceConfig = InstallerConfig.getCurrentInstance().getServiceConfigById(this.getLauncherId());
        Properties properties = this.getPersistentProperties();
        properties.setProperty(PROP_SERVICE_PATH, file.getAbsolutePath());
        properties.setProperty(PROP_SERVICE_NAME, serviceConfig.getName());
        properties.setProperty(PROP_STARTUP_TYPE, serviceConfig.getStartupType());
        try {
            if (InstallerUtil.isWindows()) {
                this.installWindows(file, serviceConfig);
            } else if (InstallerUtil.isMacOS()) {
                this.installMacos(installerContext, file, serviceConfig);
            } else {
                this.installUnix(file);
            }
        }
        catch (IOException iOException) {
            progressInterface.showFailure(MessageFormat.format(Messages.getMessages().getString("ErrorInstallService"), serviceConfig.getName()));
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public void rollback(InstallerContext installerContext) {
        this.doUninstallation(installerContext);
    }

    public boolean uninstall(UninstallerContext uninstallerContext) {
        return this.doUninstallation(uninstallerContext);
    }

    private boolean doUninstallation(Context context) {
        String string = this.getPersistentProperties().getProperty(PROP_SERVICE_PATH);
        if (string == null) {
            return true;
        }
        File file = new File(string);
        if (!file.exists()) {
            return true;
        }
        try {
            if (InstallerUtil.isWindows()) {
                this.uninstallWindows(file);
            } else if (InstallerUtil.isMacOS()) {
                this.uninstallMacos(file);
            }
        }
        catch (IOException iOException) {
            ProgressInterface progressInterface = context.getProgressInterface();
            progressInterface.showFailure(MessageFormat.format(Messages.getMessages().getString("ErrorUninstallService"), file.getName()));
            iOException.printStackTrace();
        }
        return true;
    }

    public void installUnix(File file) throws IOException {
        File file2 = new File("/etc/init.d", file.getName());
        UnixFileSystem.createLink(file.getAbsolutePath(), file2);
        FileInstaller.getInstance().registerUninstallFile(file2);
    }

    private void uninstallWindows(File file) throws IOException {
        String string = file.getAbsolutePath();
        Runtime.getRuntime().exec(new String[]{string, "/uninstall"});
    }

    private void installWindows(File file, ServiceConfig serviceConfig) throws IOException {
        if (InstallerUtil.isWindows9X()) {
            return;
        }
        String string = file.getAbsolutePath();
        boolean bl = serviceConfig.getStartupType().equals("auto");
        Process process = Runtime.getRuntime().exec(new String[]{string, "/uninstall"});
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        process = Runtime.getRuntime().exec(new String[]{string, bl ? "/install-auto" : "/install-demand"});
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void uninstallMacos(File file) throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", file.getAbsolutePath(), "stop"});
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Properties properties = this.getPersistentProperties();
        String string = properties.getProperty(PROP_SERVICE_NAME);
        String string2 = properties.getProperty(PROP_STARTUP_TYPE);
        if (string == null || !"auto".equals(string2)) {
            return;
        }
        if (string.trim().length() > 0) {
            File file2 = new File(STARTUP_ITEMS_FILE_NAME, string);
            SudoExecution.executeAndWait(new String[]{"rm", "-R", file2.getAbsolutePath()});
        }
    }

    private void installMacos(InstallerContext installerContext, File file, ServiceConfig serviceConfig) throws IOException {
        if (!serviceConfig.getStartupType().equals("auto")) {
            return;
        }
        InstallServiceAction.installStartupItem(installerContext, file, serviceConfig.getName(), serviceConfig.getDependencies());
    }

    private static void installStartupItem(Context context, File file, String string, String string2) throws IOException {
        if (!file.exists()) {
            return;
        }
        File file2 = new File(context.getDestinationFile(".install4j"), string);
        file2.mkdirs();
        File file3 = new File(file2, string);
        PrintWriter printWriter = new PrintWriter(new FileWriter(file3));
        printWriter.println("#! /bin/sh");
        printWriter.println(file.getAbsolutePath() + " $@");
        printWriter.close();
        UnixFileSystem.setMode(493, file3);
        File file4 = new File(file2, STARTUP_PARAMETERS_PLIST_NAME);
        printWriter = new PrintWriter(new FileWriter(file4));
        printWriter.println("{");
        printWriter.println("  Description     = \"" + string + "\";");
        printWriter.println("  Provides        = (\"" + string + "\");");
        printWriter.println("  Requires        = (" + InstallServiceAction.formatRequires(string2) + ");");
        printWriter.println("  OrderPreference = \"Late\";");
        printWriter.println("}");
        printWriter.close();
        File file5 = new File(STARTUP_ITEMS_FILE_NAME, string);
        SudoExecution.executeAndWait(new String[]{"mkdir", new File(STARTUP_ITEMS_FILE_NAME).getAbsolutePath()});
        SudoExecution.executeAndWait(new String[]{"rm", "-R", file5.getAbsolutePath()});
        SudoExecution.executeAndWait(new String[]{"mv", file2.getAbsolutePath(), file5.getAbsolutePath()});
        SudoExecution.executeAndWait(new String[]{"chown", "-R", "root:wheel", file5.getAbsolutePath()});
    }

    private static String formatRequires(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\"");
            stringBuffer.append(stringTokenizer.nextToken().trim());
            stringBuffer.append("\"");
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String getLauncherId() {
        return this.launcherId;
    }

    public void setLauncherId(String string) {
        this.launcherId = string;
    }

    public boolean isAddToScreen() {
        return this.addToScreen;
    }

    public void setAddToScreen(boolean bl) {
        this.addToScreen = bl;
    }

    public boolean isAllowUserChangeStartType() {
        return this.allowUserChangeStartType;
    }

    public void setAllowUserChangeStartType(boolean bl) {
        this.allowUserChangeStartType = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }
}

