/*
 * Decompiled with CFR 0.152.
 */
package coltginy;

import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.map.PrimeFinder;
import giny.model.GraphPerspective;
import giny.model.RootGraph;
import giny.view.GraphView;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;

public abstract class ColtGraphViewModel
implements GraphView {
    public double DEFAULT_X = 100.0;
    public double DEFAULT_Y = 100.0;
    public static Paint DEFAULT_NODE_PAINT = Color.lightGray;
    public static Paint DEFAULT_NODE_SELECTION_PAINT = Color.yellow;
    public static Paint DEFAULT_BORDER_PAINT = Color.black;
    public static Paint DEFAULT_EDGE_STROKE_PAINT = Color.black;
    public static Paint DEFAULT_EDGE_STROKE_PAINT_SELECTION = Color.red;
    public static Paint DEFAULT_EDGE_END_PAINT = Color.black;
    protected OpenIntObjectHashMap nodeDataStore;
    protected OpenIntObjectHashMap nodeDataDescription;
    protected OpenIntObjectHashMap edgeDataStore;
    protected OpenIntObjectHashMap edgeDataDescription;
    protected ArrayList viewDataStore;
    protected GraphPerspective perspective;
    protected String identifier;
    private static int viewCount = 0;

    public ColtGraphViewModel(GraphPerspective perspective) {
        this("View" + viewCount, perspective);
        ++viewCount;
    }

    public ColtGraphViewModel(String identifier, GraphPerspective perspective) {
        this.perspective = perspective;
        this.identifier = identifier;
        this.nodeDataStore = new OpenIntObjectHashMap(PrimeFinder.nextPrime(perspective.getNodeCount()));
        this.edgeDataStore = new OpenIntObjectHashMap(PrimeFinder.nextPrime(perspective.getEdgeCount()));
        this.viewDataStore = new ArrayList();
    }

    public RootGraph getRootGraph() {
        return this.perspective.getRootGraph();
    }

    public GraphPerspective getGraphPerspective() {
        return this.perspective;
    }

    public void setAllNodePropertyData(int node_index, Object[] data) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        this.nodeDataStore.put(node_index, data);
    }

    public Object[] getAllNodePropertyData(int node_index) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        return (Object[])this.nodeDataStore.get(node_index);
    }

    public void setAllEdgePropertyData(int edge_index, Object[] data) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        this.edgeDataStore.put(edge_index, data);
    }

    public Object[] getAllEdgePropertyData(int edge_index) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        return (Object[])this.edgeDataStore.get(edge_index);
    }

    public Object getNodeObjectProperty(int node_index, int property) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        if (this.nodeDataStore.get(node_index) != null) {
            return ((Object[])this.nodeDataStore.get(node_index))[property];
        }
        return null;
    }

    public boolean setNodeObjectProperty(int node_index, int property, Object value) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        if (this.nodeDataStore.get(node_index) instanceof Object[]) {
            Object[] data = (Object[])this.nodeDataStore.get(node_index);
            if (data.length > property) {
                ((Object[])this.nodeDataStore.get((int)node_index))[property] = value;
                return true;
            }
            Object[] new_data = new Object[property + 1];
            System.arraycopy(data, 0, new_data, 0, data.length);
            new_data[property] = value;
            this.nodeDataStore.put(node_index, new_data);
            return true;
        }
        Object[] new_data = new Object[property + 1];
        new_data[property] = value;
        this.nodeDataStore.put(node_index, new_data);
        return true;
    }

    public Object getEdgeObjectProperty(int edge_index, int property) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        if (this.edgeDataStore.get(edge_index) != null) {
            return ((Object[])this.edgeDataStore.get(edge_index))[property];
        }
        return null;
    }

    public boolean setEdgeObjectProperty(int edge_index, int property, Object value) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        if (this.edgeDataStore.get(edge_index) instanceof Object[]) {
            Object[] data = (Object[])this.edgeDataStore.get(edge_index);
            if (data.length > property) {
                ((Object[])this.edgeDataStore.get((int)edge_index))[property] = value;
                return true;
            }
            Object[] new_data = new Object[property + 1];
            System.arraycopy(data, 0, new_data, 0, data.length);
            new_data[property] = value;
            this.edgeDataStore.put(edge_index, new_data);
            return true;
        }
        Object[] new_data = new Object[property + 1];
        new_data[property] = value;
        this.edgeDataStore.put(edge_index, new_data);
        return true;
    }

    public double getNodeDoubleProperty(int node_index, int property) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        if (this.nodeDataStore.get(node_index) != null && ((Object[])this.nodeDataStore.get(node_index))[property] instanceof Double) {
            return (Double)((Object[])this.nodeDataStore.get(node_index))[property];
        }
        return 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setNodeDoubleProperty(int node_index, int property, double value) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        if (this.nodeDataStore.get(node_index) instanceof Object[]) {
            Object[] data = (Object[])this.nodeDataStore.get(node_index);
            if (data.length > property) {
                if (!(((Object[])this.nodeDataStore.get(node_index))[property] instanceof Double)) return false;
                ((Object[])this.nodeDataStore.get((int)node_index))[property] = new Double(value);
                return true;
            }
            Object[] new_data = new Object[property + 1];
            System.arraycopy(data, 0, new_data, 0, data.length);
            new_data[property] = new Double(value);
            this.nodeDataStore.put(node_index, new_data);
            return true;
        }
        Object[] new_data = new Object[property + 1];
        new_data[property] = new Double(value);
        this.nodeDataStore.put(node_index, new_data);
        return true;
    }

    public double getEdgeDoubleProperty(int edge_index, int property) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        if (this.edgeDataStore.get(edge_index) != null && ((Object[])this.edgeDataStore.get(edge_index))[property] instanceof Double) {
            return (Double)((Object[])this.edgeDataStore.get(edge_index))[property];
        }
        return 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setEdgeDoubleProperty(int edge_index, int property, double value) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        if (this.edgeDataStore.get(edge_index) instanceof Object[]) {
            Object[] data = (Object[])this.edgeDataStore.get(edge_index);
            if (data.length > property) {
                if (!(((Object[])this.edgeDataStore.get(edge_index))[property] instanceof Double)) return false;
                ((Object[])this.edgeDataStore.get((int)edge_index))[property] = new Double(value);
                return true;
            }
            Object[] new_data = new Object[property + 1];
            System.arraycopy(data, 0, new_data, 0, data.length);
            new_data[property] = new Double(value);
            this.edgeDataStore.put(edge_index, new_data);
            return true;
        }
        Object[] new_data = new Object[property + 1];
        new_data[property] = new Double(value);
        this.edgeDataStore.put(edge_index, new_data);
        return true;
    }

    public float getNodeFloatProperty(int node_index, int property) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        if (this.nodeDataStore.get(node_index) != null && ((Object[])this.nodeDataStore.get(node_index))[property] instanceof Float) {
            return ((Float)((Object[])this.nodeDataStore.get(node_index))[property]).floatValue();
        }
        return 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setNodeFloatProperty(int node_index, int property, float value) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        if (this.nodeDataStore.get(node_index) instanceof Object[]) {
            Object[] data = (Object[])this.nodeDataStore.get(node_index);
            if (data.length > property) {
                if (!(((Object[])this.nodeDataStore.get(node_index))[property] instanceof Float)) return false;
                ((Object[])this.nodeDataStore.get((int)node_index))[property] = new Float(value);
                return true;
            }
            Object[] new_data = new Object[property + 1];
            System.arraycopy(data, 0, new_data, 0, data.length);
            new_data[property] = new Float(value);
            this.nodeDataStore.put(node_index, new_data);
            return true;
        }
        Object[] new_data = new Object[property + 1];
        new_data[property] = new Float(value);
        this.nodeDataStore.put(node_index, new_data);
        return true;
    }

    public float getEdgeFloatProperty(int edge_index, int property) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        if (this.edgeDataStore.get(edge_index) != null && ((Object[])this.edgeDataStore.get(edge_index))[property] instanceof Float) {
            return ((Float)((Object[])this.edgeDataStore.get(edge_index))[property]).floatValue();
        }
        return 0.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setEdgeFloatProperty(int edge_index, int property, float value) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        if (this.edgeDataStore.get(edge_index) instanceof Object[]) {
            Object[] data = (Object[])this.edgeDataStore.get(edge_index);
            if (data.length > property) {
                if (!(((Object[])this.edgeDataStore.get(edge_index))[property] instanceof Float)) return false;
                ((Object[])this.edgeDataStore.get((int)edge_index))[property] = new Float(value);
                return true;
            }
            Object[] new_data = new Object[property + 1];
            System.arraycopy(data, 0, new_data, 0, data.length);
            new_data[property] = new Float(value);
            this.edgeDataStore.put(edge_index, new_data);
            return true;
        }
        Object[] new_data = new Object[property + 1];
        new_data[property] = new Float(value);
        this.edgeDataStore.put(edge_index, new_data);
        return true;
    }

    public boolean getNodeBooleanProperty(int node_index, int property) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        if (this.nodeDataStore.get(node_index) != null && ((Object[])this.nodeDataStore.get(node_index))[property] instanceof Boolean) {
            return (Boolean)((Object[])this.nodeDataStore.get(node_index))[property];
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setNodeBooleanProperty(int node_index, int property, boolean value) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        if (this.nodeDataStore.get(node_index) instanceof Object[]) {
            Object[] data = (Object[])this.nodeDataStore.get(node_index);
            if (data.length > property) {
                if (!(((Object[])this.nodeDataStore.get(node_index))[property] instanceof Boolean)) return false;
                ((Object[])this.nodeDataStore.get((int)node_index))[property] = new Boolean(value);
                return true;
            }
            Object[] new_data = new Object[property + 1];
            System.arraycopy(data, 0, new_data, 0, data.length);
            new_data[property] = new Boolean(value);
            this.nodeDataStore.put(node_index, new_data);
            return true;
        }
        Object[] new_data = new Object[property + 1];
        new_data[property] = new Boolean(value);
        this.nodeDataStore.put(node_index, new_data);
        return true;
    }

    public boolean getEdgeBooleanProperty(int edge_index, int property) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        if (this.edgeDataStore.get(edge_index) != null && ((Object[])this.edgeDataStore.get(edge_index))[property] instanceof Boolean) {
            return (Boolean)((Object[])this.edgeDataStore.get(edge_index))[property];
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setEdgeBooleanProperty(int edge_index, int property, boolean value) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        if (this.edgeDataStore.get(edge_index) instanceof Object[]) {
            Object[] data = (Object[])this.edgeDataStore.get(edge_index);
            if (data.length > property) {
                if (!(((Object[])this.edgeDataStore.get(edge_index))[property] instanceof Boolean)) return false;
                ((Object[])this.edgeDataStore.get((int)edge_index))[property] = new Boolean(value);
                return true;
            }
            Object[] new_data = new Object[property + 1];
            System.arraycopy(data, 0, new_data, 0, data.length);
            new_data[property] = new Boolean(value);
            this.edgeDataStore.put(edge_index, new_data);
            return true;
        }
        Object[] new_data = new Object[property + 1];
        new_data[property] = new Boolean(value);
        this.edgeDataStore.put(edge_index, new_data);
        return true;
    }

    public int getNodeIntProperty(int node_index, int property) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        if (this.nodeDataStore.get(node_index) != null && ((Object[])this.nodeDataStore.get(node_index))[property] instanceof Integer) {
            return (Integer)((Object[])this.nodeDataStore.get(node_index))[property];
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setNodeIntProperty(int node_index, int property, int value) {
        if (node_index >= 0) {
            node_index = this.perspective.getRootGraphNodeIndex(node_index);
        }
        if (this.nodeDataStore.get(node_index) instanceof Object[]) {
            Object[] data = (Object[])this.nodeDataStore.get(node_index);
            if (data.length > property) {
                if (!(((Object[])this.nodeDataStore.get(node_index))[property] instanceof Integer)) return false;
                ((Object[])this.nodeDataStore.get((int)node_index))[property] = new Integer(value);
                return true;
            }
            Object[] new_data = new Object[property + 1];
            System.arraycopy(data, 0, new_data, 0, data.length);
            new_data[property] = new Integer(value);
            this.nodeDataStore.put(node_index, new_data);
            return true;
        }
        Object[] new_data = new Object[property + 1];
        new_data[property] = new Integer(value);
        this.nodeDataStore.put(node_index, new_data);
        return true;
    }

    public int getEdgeIntProperty(int edge_index, int property) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        if (this.edgeDataStore.get(edge_index) != null && ((Object[])this.edgeDataStore.get(edge_index))[property] instanceof Integer) {
            return (Integer)((Object[])this.edgeDataStore.get(edge_index))[property];
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setEdgeIntProperty(int edge_index, int property, int value) {
        if (edge_index >= 0) {
            edge_index = this.perspective.getRootGraphEdgeIndex(edge_index);
        }
        if (this.edgeDataStore.get(edge_index) instanceof Object[]) {
            Object[] data = (Object[])this.edgeDataStore.get(edge_index);
            if (data.length > property) {
                if (!(((Object[])this.edgeDataStore.get(edge_index))[property] instanceof Integer)) return false;
                ((Object[])this.edgeDataStore.get((int)edge_index))[property] = new Integer(value);
                return true;
            }
            Object[] new_data = new Object[property + 1];
            System.arraycopy(data, 0, new_data, 0, data.length);
            new_data[property] = new Integer(value);
            this.edgeDataStore.put(edge_index, new_data);
            return true;
        }
        Object[] new_data = new Object[property + 1];
        new_data[property] = new Integer(value);
        this.edgeDataStore.put(edge_index, new_data);
        return true;
    }
}

