/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.misc.DelegatedRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.NoSynchRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;

class SyncDelegatedRNG
extends DelegatedRNG {
    protected final Sync cond_;

    public SyncDelegatedRNG(Sync sync) {
        this.cond_ = sync;
        this.setDelegate((RNG)new NoSynchRNG());
    }

    protected final void acquire() throws InterruptedException {
        if (this.smode == 0) {
            this.cond_.acquire();
        } else {
            while (!this.cond_.attempt(this.waitTime)) {
            }
        }
    }

    public long next() {
        try {
            this.acquire();
            this.getDelegate().update();
            long l = this.getDelegate().get();
            this.cond_.release();
            return l;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return 0L;
        }
    }

    public long get() {
        try {
            this.acquire();
            long l = this.getDelegate().get();
            this.cond_.release();
            return l;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return 0L;
        }
    }

    public void update() {
        try {
            this.acquire();
            this.getDelegate().update();
            this.cond_.release();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }
}

