### R code from vignette source 'Clonality.Rnw'

###################################################
### code chunk number 1: load libraries
###################################################
library(DNAcopy)
library(Clonality)
library(gdata)


###################################################
### code chunk number 2: read data
###################################################
data<-read.xls("http://waldman.ucsf.edu/Breast/Hwang.data.xls")
data<-data[!is.na(data[,2]),]
data<-data[apply(is.na(data),1,sum)<=50,]
data<-data[,apply(is.na(data),2,sum)<=1000] 


###################################################
### code chunk number 3: Clonality.Rnw:64-65
###################################################
data[1:5,1:10]


###################################################
### code chunk number 4: prep data
###################################################
arrayinfo<-read.xls("http://waldman.ucsf.edu/Colon/nakao.data.xls")  #needed to extract  genomic locations
data$Position<-arrayinfo$Mb[match(toupper(as.character(data[,1])),toupper(as.character(arrayinfo[,1])))]
data<-data[!is.na(data$Position),]


###################################################
### code chunk number 5: remove repeated maplocs
###################################################
length(unique(paste(data$Chromosome, data$Position))) #there are repeated genomic locations
data<-data[c(TRUE,data$Position[-1]!=data$Position[-1864]),] #discard probes with repeated genomic locations
data<-data[data$Chromosome<=22,] #getting rid of X and Y chromosomes


###################################################
### code chunk number 6: Clonality.Rnw:86-87
###################################################
dim(data)


###################################################
### code chunk number 7: CNA
###################################################
dataCNA<-CNA(as.matrix(data[,c(4:6,28:30)]),maploc=data$Position,chrom=data$Chromosome,sampleid=names(data)[c(4:6,28:30)]) #taking the first 3 patients only to shorten the computation time; use c(4:51) for the full dataset


###################################################
### code chunk number 8: averaging
###################################################
dataAve<- ave.adj.probes(dataCNA,2)


###################################################
### code chunk number 9: split chromosomes
###################################################
dataCNA$maploc<-dataCNA$maploc*1000 #transforming maploc to Kb scale
dataCNA$chrom<- splitChromosomes(dataCNA$chrom,dataCNA$maploc)  #splits the chromosomes into arms


###################################################
### code chunk number 10: Clonality.Rnw:117-118
###################################################
ptlist<-substr(names(dataCNA)[-c(1,2)],1,4)


###################################################
### code chunk number 11: main clonality analysis
###################################################
results<-clonality.analysis(dataCNA, ptlist,   nmad = 1.25,  reference = TRUE, allpairs = FALSE)


###################################################
### code chunk number 12: Clonality.Rnw:127-128
###################################################
results$LR


###################################################
### code chunk number 13: genomewidePlots
###################################################
genomewidePlots(results$OneStepSeg, results$ChromClass,ptlist , c("LC03LCIS", "LC03ILC"),results$LR,  plot.as.in.analysis = TRUE) 


###################################################
### code chunk number 14: Clonality.Rnw:147-148
###################################################
histogramPlot(results$LR[,4], results$refLR[,4])


###################################################
### code chunk number 15: LOH data generation
###################################################
set.seed(25)
LOHtable<-cbind(1:20,matrix(sample(c(0,1,2),20*20,replace=TRUE),20))
LOHtable[,3]<-LOHtable[,2]
LOHtable[1,3]<-0


###################################################
### code chunk number 16: LOH data analysis
###################################################
LOHtable[,1:5]
LOHclonality(LOHtable,rep(1:10,each=2),pfreq=NULL,noloh=0,loh1=1,loh2=2)


###################################################
### code chunk number 17: sessionInfo
###################################################
sessionInfo()


