### R code from vignette source 'CGHcall.Rnw'

###################################################
### code chunk number 1: CGHcall.Rnw:45-48
###################################################
library(CGHcall)
data(WiltingData)
Wilting <- cghRaw(WiltingData)


###################################################
### code chunk number 2: CGHcall.Rnw:60-61
###################################################
cghdata <- preprocess(Wilting, maxmiss=30, nchrom=22)


###################################################
### code chunk number 3: CGHcall.Rnw:66-68
###################################################
tumor.prop <- c(0.75, 0.9, 0.8, 1, 1)
norm.cghdata <- normalize(cghdata, method="median", cellularity=tumor.prop, smoothOutliers=TRUE)


###################################################
### code chunk number 4: CGHcall.Rnw:73-75
###################################################
norm.cghdata <- norm.cghdata[,1:2]
seg.cghdata <- segmentData(norm.cghdata, method="DNAcopy")


###################################################
### code chunk number 5: CGHcall.Rnw:80-81
###################################################
postseg.cghdata <- postsegnormalize(seg.cghdata)


###################################################
### code chunk number 6: CGHcall.Rnw:86-87
###################################################
result <- CGHcall(postseg.cghdata)


###################################################
### code chunk number 7: CGHcall.Rnw:92-93
###################################################
result <- ExpandCGHcall(result,postseg.cghdata)


###################################################
### code chunk number 8: CGHcall.Rnw:101-102
###################################################
plot(result[,1])


###################################################
### code chunk number 9: CGHcall.Rnw:108-109
###################################################
plot(result[,2])


###################################################
### code chunk number 10: CGHcall.Rnw:118-119
###################################################
summaryPlot(result)


