### Name: ath1121501ACCNUM
### Title: Map between manufacturer IDs and AGI locus IDs
### Aliases: ath1121501ACCNUM ath1121501MULTIHIT
### Keywords: datasets

### ** Examples

  x <- ath1121501ACCNUM
  y <- ath1121501MULTIHIT
  identical(keys(x), keys(y))    # TRUE

  nhx <- nhit(x)
  nhy <- nhit(y)
  identical(names(nhx), keys(x)) # TRUE
  identical(names(nhy), keys(y)) # TRUE
  table(nhx)
  table(nhy)

  onehit_probes <- names(nhx)[nhx != 0 & nhy == 0]
  x[[onehit_probes[1]]]          # a single AGI locus ID
  y[[onehit_probes[1]]]          # NA

  multihit_probes <- names(nhx)[nhy != 0]
  x[[multihit_probes[1]]]        # "multiple"
  y[[multihit_probes[1]]]        # several AGI locus IDs

  nohit_probes <- names(nhx)[nhx == 0]
  x[[nohit_probes[1]]]           # NA
  y[[nohit_probes[1]]]           # NA

  any(nhx == 0 & nhy != 0)       # FALSE

  ## Back to a more "normal" map (that combines the data from 'x' and 'y')
  xy <- as(x, "AnnDbBimap")      # 'as(y, "AnnDbBimap")' works too
  xy[[onehit_probes[1]]]         # a single AGI locus ID
  xy[[multihit_probes[1]]]       # several AGI locus IDs
  xy[[nohit_probes[1]]]          # NA



