### Name: twilight.filtering
### Title: A function for permutation filtering
### Aliases: twilight.filtering
### Keywords: datagen

### ** Examples

## Not run: 
##D ### Leukemia data set of Golub et al. (1999).
##D library(golubEsets)
##D data(Golub_Train)
##D 
##D ### Variance-stabilizing normalization of Huber et al. (2002).
##D library(vsn)
##D golubNorm <- vsn(exprs(Golub_Train))
##D 
##D ### A binary vector of class labels.
##D id <- as.numeric(Golub_Train$ALL.AML)
##D 
##D ### Do an unpaired t-test.
##D ### Let's have a quick example with 50 filtered permutations only.
##D ### With num.take=10, we only need 5 iteration steps.
##D yperm <- twilight.filtering(golubNorm,id,method="t",num.perm=50,num.take=10)
##D dim(yperm)
##D 
##D ### Let's see if the filtered permutations really produce uniform p-value distributions.
##D ### The first row is the original labeling, so we try the second permutation.
##D yperm <- yperm[-1,]
##D b <- twilight.pval(golubNorm,yperm[1,],method="t",yperm=yperm)
##D hist(b$result$pvalue)
## End(Not run)



