### Name: spotseg
### Title: Microarray Spot Segmentation
### Aliases: spotseg
### Keywords: manip robust cluster

### ** Examples

data(spotSegTest)

# columns of spotSegTest:
#  1 intensities from the Cy3 (green) channel
#  2 intensities from the Cy5 (red) channel

dataTransformation <- function(x) (256*256-1-x)^2*4.71542407E-05 

chan1 <- matrix(dataTransformation(spotSegTest[,1]), 144, 199)
chan2 <- matrix(dataTransformation(spotSegTest[,2]), 144, 199)

Grid <- spotgrid( chan1, chan2, rows = 4, cols = 6, show = TRUE)

library(mclust)

Seg <- spotseg( chan1, chan2, Grid$rowcut, Grid$colcut)

plot(Seg)

spotSummary <- summary(Seg)

spot11 <- spotseg( chan1, chan2, Grid$rowcut, Grid$colcut, 
                    R = 1, C = 1, show = TRUE)



