### Name: find.a0
### Title: Computation of the Fudge Factor
### Aliases: find.a0
### Keywords: htest

### ** Examples
## Not run: 
##D   # Load the data of Golub et al. (1999) contained in the package multtest.
##D   data(golub)
##D   
##D   # golub.cl contains the class labels.
##D   golub.cl
##D   
##D   # Obtain the number of differentially expressed genes and the FDR for the
##D   # default set of values for the fudge factor.
##D   find.out <- find.a0(golub, golub.cl, rand = 123)
##D   find.out
##D   
##D   # Obtain the number of differentially expressed genes and the FDR when using
##D   # the t-statistic assuming equal group variances
##D   find.out2 <- find.a0(golub, golub.cl, var.equal = TRUE, rand = 123)
##D   
##D   # Using the Output of the first analysis with find.a0, the number of 
##D   # differentially expressed genes and the FDR for other values of
##D   # delta, e.g., 0.95, can be obtained by
##D   print(find.out, 0.95)
##D   
##D   # The logit-transformed posterior probabilities can be plotted by
##D   plot(find.out)
##D   
##D   # To avoid the logit-transformation, set logit = FALSE.
##D   plot(find.out, logit = FALSE)
## End(Not run)


