### Name: showgate.FCS
### Title: Showing the gate and the datapoints within the gate on a prevous
###   plot
### Aliases: showgate.FCS
### Keywords: aplot

### ** Examples


  if (interactive()){
  if (require(rfcdmin)){
    ## obtaining the FCS objects from VRC data
    if ( !(is.element("unst.1829", objects())
                    & is.element("st.1829", objects())) ){
      data(VRCmin)
    }

    ## univariate plot
    plotvar.FCS(unst.1829, type="uni", varpos=1, plotType=hist)
    ## show cut off at 350
    showgate.FCS(unst.1829@data[,1], type="uniscut", gatingrange=350)
    ## show different cutoff at 500
    showgate.FCS(unst.1829@data[,1], type="uniscut", gatingrange=500,
                 coltype="green")

    ## bivariate plot : rectanglar bins in which the gate can be shown
    plotvar.FCS(unst.1829, type="bi", varpos=c(1,2), hexbin.CSPlot=FALSE)
    ## show cutoff at 275 to 600 for both variables
    ## may take a while
    ## create the gate index as the first column entry of the "gate" matrix
    unst.1829.gt<-createGate(unst.1829, varpos=1:2, type="bidcut",
          gatingrange=c(275, 600, 275, 600))

    ## show the gate
    showgate.FCS(unst.1829.gt@data[,c(1,2)], unst.1829.gt@gate[,1],
       type="bidcut", gatingrange=c(275, 600, 275, 600))

    }
  }




