### Name: plotECDF.FCS
### Title: Create a empirical cumulative distribution plot for one (or
###   more) parameter(s) of one (or more) FCS object(s)
### Aliases: plotECDF.FCS
### Keywords: hplot

### ** Examples

 require(rfcdmin)
 require(lattice)

 ##Example I:
 data(flowcyt.data)

 ##Draw an empirical cumulative density plot for the Foward scatter
 ##parameter of the different stains at a particular different time point
 ##(one panel per time point).
 plotECDF.FCS(flowcyt.data,varpos=c(1),var.list=c(paste("time",1:12,sep="")),group.list=paste("Stain",c(1:8),sep=""),main="ECDF plot of the FSC parameter for different stains across time points",lwd=2,cex=1.5,type="l")

 ##Example II:
 if (require(rfcdmin)) {
  ##Obtain the location of the fcs files 
  pathFiles<-system.file("bccrc", package="rfcdmin")
  drugFiles<-dir(pathFiles)

  ##Read a serie of FCS files
  drugData<-read.series.FCS(drugFiles,path=pathFiles,MY.DEBUG=FALSE)
  }

  ##Draw a empirical cumulative density plot for the Foward scatter
 ##parameter for the differents aliquots (of the same cell line)
 ##treated with different compounds. 
 plotECDF.FCS(drugData,varpos=c(1),var.list=c("Serie"),group.list=paste("compound",c(1:8),sep=""),main="ECDF plot for the aliquots treated with different compounds.",lwd=2,cex=1.5,type="l")
 


