### Name: cytoSet-class
### Title: 'cytoSet': a class for storing raw data from a quantitative
###   cell-based assay
### Aliases: cytoSet-class [,cytoSet-method [[,cytoSet-method
###   [[<-,cytoSet-method show,cytoSet-method length,cytoSet-method
###   pData,cytoSet-method colnames,cytoSet-method
###   colnames<-,cytoSet-method phenoData,cytoSet-method
###   phenoData<-,cytoSet,phenoData-method
### Keywords: classes

### ** Examples

if (require(prada)) {
cset<-readCytoSet(path=system.file("extdata", package="prada"),
  pattern="[A-Z][0-9][0-9]$")
cset
pData(cset)
cset[[1]]
cset[["fas-Bcl2-plate323-04-04.A02"]]
cset["fas-Bcl2-plate323-04-04.A02"]
cset[1:3]
cset[[1]] <- exprs(cset[[1]])[1:100, ]

plot(cset[[2]])
}

if (require(rfcdmin) && require(prada)) {

 ##obtaining the location of the fcs files in the data
  pathFiles<-system.file("bccrc", package="rfcdmin")
  drugFiles<-dir(pathFiles)

 ## reading in the FCS files
  drugData<-readCytoSet(path=system.file("bccrc", package="rfcdmin"),pattern="[A-Z][0-9][0-9]$")
  }



