### Name: convertS3toS4
### Title: Converts S3 class FCS object to S4 class FCS object
### Aliases: convertS3toS4
### Keywords: classes character

### ** Examples

  if (require(rfcdmin)){

     ## if previously read-in as S3 FCS object
     facscan256.fcs<- paste(system.file("fcs", package="rfcdmin"),
                              "facscan256.fcs",
                              sep="/")

     ## reading in the FCS files
     FCSobj.S3<-read.FCS(facscan256.fcs, UseS3=TRUE)

     ## convert to S4 FCS

     FCSobj.S4<- convertS3toS4(FCSobj.S3,
                               myFCSobj.name="FCSobj.S4",
                               fileName=facscan256.fcs)
  }



