### Name: PercentPos.FCS
### Title: Calculate the Percent Positive given a percentile
### Aliases: PercentPos.FCS percentile.FCS
### Keywords: dplot math

### ** Examples


if (require(rfcdmin)){

data.there<-is.element(c("st.1829", "unst.1829", "unst.DRT", "st.DRT"),objects())
if ( ( sum(data.there) != length(data.there) )){
## obtaining the FCS objects from VRC data
data(VRCmin)
}
#hiv negative one individual, 1829
#stimulated sample
INFg.st.neg<-st.1829@data[,4]
#control sample
INFg.unst.neg<-unst.1829@data[,4]

#hiv positive one individual, DRT
#stimulated sample
INFg.st.pos<-st.DRT@data[,4]
#control sample
INFg.unst.pos<-unst.DRT@data[,4]

c.neg<-percentile.FCS(INFg.unst.neg)
c.pos<-percentile.FCS(INFg.unst.pos)

#percent positive for two individuals
p.neg<-PercentPos.FCS(INFg.st.neg, c.neg)
p.pos<-PercentPos.FCS(INFg.st.pos, c.pos)

### percentage positive
ptg.neg<-100*p.neg$percent.pos
ptg.pos<-100*p.pos$percent.pos
}




