### Name: ContourScatterPlot
### Title: Image and Contour Bivariate Plot
### Aliases: ContourScatterPlot
### Keywords: hplot

### ** Examples

##Example I: with a  FSC object
  if (require(rfcdmin)){
    data.there<-is.element("MC.053",objects())
    if ((sum(data.there) != length(data.there))) {
      ## obtaining the FCS objects from FHCRC data
      data(MC.053min)
    }
    ## obtain the two column variables
    xvar<-MC.053@data[,1]
    yvar<-MC.053@data[,2]

    ## have an example plot
    if (interactive()==TRUE) {

      ## rectangular cells with the contour plot 
      ContourScatterPlot(xvar, yvar,
                        xlab=colnames(MC.053@data)[1],
                        ylab=colnames(MC.053@data)[2],
                        main="Individual 042402c1.053",
                        hexbin.plotted=FALSE,
                        numlev=25, image.col=heat.colors(15),
                        plot.legend.CSP=TRUE)

      ## hexagon cells without contour lines; default n.hexbins=100
      ContourScatterPlot(xvar, yvar,
                        xlab=colnames(MC.053@data)[1],
                        ylab=colnames(MC.053@data)[2],
                        main="Individual 042402c1.053",
                       hexbin.plotted=TRUE)
      ## finer hexgonal binning
        ContourScatterPlot(xvar, yvar,
                        xlab=colnames(MC.053@data)[1],
                        ylab=colnames(MC.053@data)[2],
                        main="Individual 042402c1.053",
                        hexbin.plotted=TRUE, n.hexbins=300)

## and with some additional
      ## plot.hexbin options
      ContourScatterPlot(xvar, yvar,
                         xlab=colnames(MC.053@data)[1],
                         ylab=colnames(MC.053@data)[2],
                         main="Individual 042402c1.053", hexbin.plotted=TRUE,
                         minarea=1, maxarea=1)

      ## different hexbin styles

      ContourScatterPlot(xvar, yvar,
                         xlab=colnames(MC.053@data)[1],
                         ylab=colnames(MC.053@data)[2],
                         main="Hexbin.style=colorscale", hexbin.plotted=TRUE,
                         hexbin.style="colorscale")
      ContourScatterPlot(xvar, yvar,
                         xlab=colnames(MC.053@data)[1],
                         ylab=colnames(MC.053@data)[2],
                         main="Hexbin.style=lattice", hexbin.plotted=TRUE,
                         hexbin.style="lattice")
      ContourScatterPlot(xvar, yvar,
                         xlab=colnames(MC.053@data)[1],
                         ylab=colnames(MC.053@data)[2],
                         main="Hexbin.style=centroids", hexbin.plotted=TRUE,
                         hexbin.style="centroids")

      ContourScatterPlot(xvar, yvar,
                         xlab=colnames(MC.053@data)[1],
                         ylab=colnames(MC.053@data)[2],
                         main="Hexbin.style=nested.lattice", hexbin.plotted=TRUE,
                         hexbin.style="nested.lattice")
      ContourScatterPlot(xvar, yvar,
                         xlab=colnames(MC.053@data)[1],
                         ylab=colnames(MC.053@data)[2],
                         main="Hexbin.style=nested.centroids", hexbin.plotted=TRUE,
                         hexbin.style="nested.centroids")
      }
## See example(make.density) for examples of 'image' of
## grid images with values estimated from 'status'; ie plots of
## differences between stimulated and unstimulated
## HIV-protein 'status' scenarios

if ( ( sum(data.there) != length(data.there) )){
      ## obtaining the FCS objects from VRC data
      data(VRCmin)
  }

var1<-st.DRT@data[,4]
var2<-st.DRT@data[,5]
var1.2<-unst.DRT@data[,4]
var2.2<-unst.DRT@data[,5]

col.nm<-colnames(st.DRT@data)

## The status where 1=stimulated
## 0 = unstimulated
status<-c(rep(1, dim(st.DRT@data)[1]), rep(0, dim(unst.DRT@data)[1]))
x <- c(var1, var1.2)
y <-c(var2, var2.2)

if (interactive()){
par(mfrow=c(3,4))
ContourScatterPlot(var1, var2, 
  main="make.grid: Counts for stimulated",
   xlab=col.nm[4],
   ylab=col.nm[5], image.col=heat.colors(20),plot.legend.CSP=TRUE)

ContourScatterPlot(x, y,
  main="make.grid: Counts for unstimulated",
   xlab=col.nm[4],
   ylab=col.nm[5], image.col=heat.colors(20),plot.legend.CSP=TRUE)

## white cells are those with NO data
ContourScatterPlot(x, y,  status=status,
  type.CSP="count.diff",
  main="Count difference between Stimulated and unstimulated",
   xlab=col.nm[4],
   ylab=col.nm[5], image.col=c("brown","lightyellow"))

ContourScatterPlot(x, y,  status=status,
  type.CSP="p.hat",
  main="Proportion of Stimulated",
   xlab=col.nm[4],
   ylab=col.nm[5], image.col=c("brown","lightyellow"))

ContourScatterPlot(x, y,  status=status,
   main="Normalized proportion of Stimulated",
   xlab=col.nm[4],
   ylab=col.nm[5], image.col=c("brown","lightyellow"))

ContourScatterPlot(x, y,  status=status,
   main="z statistic",
   xlab=col.nm[4],
   ylab=col.nm[5], image.col=c("brown","lightyellow"))
}

}

##Example II: with a  CytoFrame object
 if (require(rfcdmin)) {

 ##obtaining the location of the fcs files in the data
  pathFiles<-system.file("bccrc", package="rfcdmin")
  drugFiles<-dir(pathFiles)

 ## reading in the FCS files
  drugData<-read.series.FCS(drugFiles,path=pathFiles,MY.DEBUG=FALSE)
  xvar <- fluors(drugData[[1]])[,1]
  yvar <- fluors(drugData[[1]])[,2]
  if (interactive()==TRUE) {
    ContourScatterPlot(xvar, yvar,
                         xlab=colnames(exprs(drugData[[1]]))[1],
                         ylab=colnames(exprs(drugData[[1]]))[2],
                         main="Contour plot",
                         hexbin.plotted=FALSE,
                         numlev=25, image.col= c("gray82", "blue"),
                         plot.legend.CSP=TRUE)
                         }
}
 



