### Name: numFP
### Title: Number of False Positives for a given proportion of True
###   Positives.
### Aliases: numFP
### Keywords: manip

### ** Examples

class1a <- rnorm(1000,0.2,0.1)
class2a <- rnorm(1000,0.6,0.2)
class1b <- rnorm(1000,0.3,0.1)
class2b <- rnorm(1000,0.5,0.2)
scores_a <- c(class1a, class2a)
scores_b <- c(class1b, class2b)
classElts <- c(rep(FALSE,1000), rep(TRUE,1000))
print(numFP(scores_a, classElts))
print(numFP(scores_b, classElts))

## The function is currently defined as
function (scoresList, truthValues, TPRate = 0.5) 
{
    numberOfTPToCount <- length(which(truthValues)) * TPRate
    scoresIndex <- sort(scoresList, decreasing = TRUE, index.return = TRUE)$ix
    numberOfFP <- 0
    numberOfTP <- 0
    for (i in 1:length(scoresIndex)) {
        if (truthValues[scoresIndex[i]]) 
            numberOfTP <- numberOfTP + 1
        else numberOfFP <- numberOfFP + 1
        if (numberOfTP >= numberOfTPToCount) 
            return(numberOfFP)
    }
  }



