### Name: createDesignMatrix
### Title: Automatically create a design matrix from an ExpressionSet
### Aliases: createDesignMatrix
### Keywords: manip

### ** Examples

        # This is a simple example based on a real data set. Note that this is an "unbalanced" design, the "level" factor has two replicates of the "twenty" condition, but only one replicate of the "ten" condition. Also note that the second factor, "batch" is not used in the design or contrast matrices, as we don't have every combination of the levels of "level" and "batch" (there is no array for level=twenty and batch=B).
                
        data(affybatch.example)
        pData(affybatch.example) <- data.frame("level"=c("twenty","twenty","ten")
            , "batch"=c("A","B","A"), row.names=rownames(pData(affybatch.example)))
        eset_mmgmos <- mmgmos(affybatch.example)
        createDesignMatrix(eset_mmgmos)
        
        # The following shows a set of 15 synthetic data sets with increasing complexity. We first create the data sets, then look at the design matrices.

        # single 2-level factor
        eset1 <- new("ExpressionSet", exprs=matrix(0,100,4))
        pData(eset1) <- data.frame("class"=c(1,1,2,2))

        # single 2-level factor - unbalanced design
        eset2 <- new("ExpressionSet", exprs=matrix(0,100,4))
        pData(eset2) <- data.frame("class"=c(1,2,2,2))

        # single 3-level factor
        eset3 <- new("ExpressionSet", exprs=matrix(0,100,6))
        pData(eset3) <- data.frame("class"=c(1,1,2,2,3,3))

        # single 4-level factor
        eset4 <- new("ExpressionSet", exprs=matrix(0,100,8))
        pData(eset4) <- data.frame("class"=c(1,1,2,2,3,3,4,4))

        # 2x2 factorial
        eset5 <- new("ExpressionSet", exprs=matrix(0,100,8))
        pData(eset5) <- data.frame("fac1"=c("a","a","a","a","b","b","b","b"), "fac2"=c(1,1,2,2,1,1,2,2))

        # 2x2 factorial - unbalanced design
        eset6 <- new("ExpressionSet", exprs=matrix(0,100,10))
        pData(eset6) <- data.frame("fac1"=c("a","a","a","b","b","b","b","b","b","b"), "fac2"=c(1,2,2,1,1,1,2,2,2,2))

        # 3x2 factorial
        eset7 <- new("ExpressionSet", exprs=matrix(0,100,12))
        pData(eset7) <- data.frame("fac1"=c("a","a","a","a","b","b","b","b","c","c","c","c"), "fac2"=c(1,1,2,2,1,1,2,2,1,1,2,2))

        # 2x3 factorial
        eset8 <- new("ExpressionSet", exprs=matrix(0,100,12))
        pData(eset8) <- data.frame(
                "fac1"=c("a","a","a","a","a","a","b","b","b","b","b","b")
        ,       "fac2"=c(1,1,2,2,3,3,1,1,2,2,3,3) )

        # 2x2x2 factorial
        eset9 <- new("ExpressionSet", exprs=matrix(0,100,8))
        pData(eset9) <- data.frame(
                "fac1"=c("a","a","a","a","b","b","b","b")
        ,       "fac2"=c(1,1,2,2,1,1,2,2)
        ,       "fac3"=c("X","Y","X","Y","X","Y","X","Y") )

        # 3x2x2 factorial
        eset10 <- new("ExpressionSet", exprs=matrix(0,100,12))
        pData(eset10) <- data.frame(
                "fac1"=c("a","a","a","a","b","b","b","b","c","c","c","c")
        ,       "fac2"=c(1,1,2,2,1,1,2,2,1,1,2,2)
        ,       "fac3"=c("X","Y","X","Y","X","Y","X","Y","X","Y","X","Y") )

        # 3x2x2 factorial
        eset11 <- new("ExpressionSet", exprs=matrix(0,100,12))
        pData(eset11) <- data.frame(
                "fac1"=c("a","a","a","a","a","a","b","b","b","b","b","b")
        ,       "fac2"=c(1,1,2,2,3,3,1,1,2,2,3,3)
        ,       "fac3"=c("X","Y","X","Y","X","Y","X","Y","X","Y","X","Y") )

        # 3x2x2 factorial
        eset12 <- new("ExpressionSet", exprs=matrix(0,100,18))
        pData(eset12) <- data.frame(
                "fac1"=c("a","a","a","a","a","a","b","b","b","b","b","b","c","c","c","c","c","c")
        ,       "fac2"=c(1,1,2,2,3,3,1,1,2,2,3,3,1,1,2,2,3,3)
        ,       "fac3"=c("X","Y","X","Y","X","Y","X","Y","X","Y","X","Y","X","Y","X","Y","X","Y") )

        # 2x2x2x2 factorial
        eset13 <- new("ExpressionSet", exprs=matrix(0,100,16))
        pData(eset13) <- data.frame(
                "fac1"=c("a","a","a","a","a","a","a","a","b","b","b","b","b","b","b","b")
        ,       "fac2"=c(0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1)
        ,       "fac3"=c(2,2,3,3,2,2,3,3,2,2,3,3,2,2,3,3)
        ,       "fac4"=c("X","Y","X","Y","X","Y","X","Y","X","Y","X","Y","X","Y","X","Y") )

        # "Un-analysable" data set - all arrays are from the same class
        eset14 <- new("ExpressionSet", exprs=matrix(0,100,4))
        pData(eset14) <- data.frame("class"=c(1,1,1,1))

        # "Non-factorial" data set - there are no arrays for fac1="b" and fac2=2. In this case only the first factor (fac1) is used.
        eset15 <- new("ExpressionSet", exprs=matrix(0,100,6))
        pData(eset15) <- data.frame("fac1"=c("a","a","a","a","b","b"), "fac2"=c(1,1,2,2,1,1))

        createDesignMatrix(eset1)
        createDesignMatrix(eset2)
        createDesignMatrix(eset3)
        createDesignMatrix(eset4)
        createDesignMatrix(eset5)
        createDesignMatrix(eset6)
        createDesignMatrix(eset7)
        createDesignMatrix(eset8)
        createDesignMatrix(eset9)
        createDesignMatrix(eset10)
        createDesignMatrix(eset11)
        createDesignMatrix(eset12)
        createDesignMatrix(eset13)

        # "Un-analysable" data set - all arrays are from the same class - gives an error. Note that we've commented this out so that we don't get errors which would make the package fail the Bioconductor checks!
        # createDesignMatrix(eset14)
        # "Non-factorial" data set - there are no arrays for fac1="b" and fac2=2. In this case only the first factor (fac1) is used.
        createDesignMatrix(eset15)




