### Name: calculateLimma
### Title: Calculate differential expression between conditions using limma
### Aliases: calculateLimma
### Keywords: manip

### ** Examples

        library(puma)
        data(affybatch.example)
        pData(affybatch.example) <- data.frame("level"=c("twenty","twenty","ten")
            , "batch"=c("A","B","A"), row.names=rownames(pData(affybatch.example)))
        eset_rma <- rma(affybatch.example)
        limmaRes <- calculateLimma(eset_rma)
        topGeneIDs(limmaRes,numberOfGenes=6)
        plotErrorBars(eset_rma, topGenes(limmaRes))



