### Name: transitive.closure
### Title: Computes the transitive closure of a directed graph
### Aliases: transitive.closure
### Keywords: graphs

### ** Examples

   V <- LETTERS[1:3]
   edL <- list(A=list(edges="B"),B=list(edges="C"),C=list(edges=NULL))
   g <- new("graphNEL",nodes=V,edgeL=edL,edgemode="directed")
   gc <- transitive.closure(g,loops=FALSE)
    
   par(mfrow=c(1,2))
   plot(g,main="NOT transitively closed")
   plot(gc,main="transitively closed")



