### Name: read.marrayLayout
### Title: Create objects of class marrayLayout
### Aliases: read.marrayLayout widget.marrayLayout
### Keywords: file connection

### ** Examples

datadir <- system.file("swirldata", package="marray")

### Reading in control information from file
skip <-  grep("Row", readLines(file.path(datadir,"fish.gal"), n=100)) - 1
swirl.layout <- read.marrayLayout(fname=file.path(datadir,"fish.gal"), ngr=4, ngc=4,
nsr=22, nsc=24, ctl.col=4, skip=skip)

### Setting control information.
swirl.gnames <- read.marrayInfo(file.path(datadir,"fish.gal"), info.id=4:5, labels=5, skip=21)
x <-  maInfo(swirl.gnames)[,1]
y <- rep(0, maNspots(swirl.layout))
y[x == "control"] <- 1
slot(swirl.layout, "maControls") <- as.factor(y)



