### Name: resiplot
### Title: Residual plot for Micro Array Experiment
### Aliases: resiplot
### Keywords: hplot

### ** Examples

# load in Paigen's data
data(paigen)
# make data object with rep 2
paigen <- createData(paigen.raw, 2)
# Note that the data is normalized so normalization is skipped
# full model
model.full.fix <- makeModel(data=paigen,
      formula=~Dye+Array+Spot+Strain+Diet+Strain:Diet)
anova.full.fix <- fitmaanova(paigen, model.full.fix)
# residual plot
resiplot(paigen, anova.full.fix)



