### Name: macluster
### Title: Clustering analysis for Micro Array experiment
### Aliases: macluster
### Keywords: cluster

### ** Examples

# load in data
data(paigen)
# make data object with rep 2
paigen <- createData(paigen.raw, 2)
# make interactive model
model.int.fix <- makeModel(data=paigen,
      formula=~Dye+Array+Strain+Diet+Strain:Diet)
# fit ANOVA model
anova.int <- fitmaanova(paigen, model.int.fix)
# test interaction effect 
## Not run: test.int.fix <- matest(paigen, model.int.fix, term="Strain:Diet", n.perm=100)
##D # pick significant genes - pick the genes selected by Fs test
##D idx <- volcano(test.int.fix)$idx.Fs
##D 
##D # do k-means cluster on genes
##D gene.cluster <- macluster(anova.int, "Strain:Diet", idx, "gene",
##D     "kmean", kmean.ngroups=5)
##D # get the consensus group
##D consensus(gene.cluster, 0.5)
##D 
##D # HC cluster on samples
##D sample.cluster <- macluster(anova.int, "Strain:Diet", idx, "sample","hc")
##D # get the consensus group
##D consensus(sample.cluster, 0.5)
## End(Not run)



