### Name: fill.missing
### Title: Fill in missing data
### Aliases: fill.missing
### Keywords: utilities

### ** Examples

data(abf1)
# randomly generate some missing data 
rawdata <- abf1.raw
ndata <- length(abf1.raw$data)
pct.missing <- 0.05 # 5
idx.missing <- sample(ndata, floor(ndata*pct.missing))
rawdata$data[idx.missing] <- NA
rawdata <- fill.missing(rawdata)
# plot impute data versus original data
plot(rawdata$data[idx.missing], abf1.raw$data[idx.missing])
abline(0,1)



