### Name: idiogram
### Title: Plotting of Genomic Data
### Aliases: idiogram midiogram
### Keywords: hplot

### ** Examples

library(idiogram)

## 
## NOTE:This requires an annotation package to work.
##      In this example packages "hu6800" and "golubEsets" are used.
##      They can be downloaded from http://www.bioconductor.org
##      "hu6800" is under MetaData, "golubEsets" is under Experimental
##      Data.

if(require(hu6800) && require(golubEsets)) {
   library(golubEsets)
   data(Golub_Train)

   hu.chr <- buildChromLocation("hu6800")
   ex <- assayData(Golub_Train)$exprs[,1]

   ## make sure the names() attribute is set correctly
   gN <- names(ex)
   gN[1:10]   

   idiogram(ex,hu.chr,chr="1")

   colors <- rep("black",times=length(ex))
   colors[ex > 10000] <- "red"
   pts <- rep(1,times=length(ex))
   pts[ex > 10000] <- 2
   idiogram(ex,hu.chr,chr="1",col=colors,pch=pts,font.axis=2,cex.axis=1)
   abline(v=0,col="darkgreen")

   ## An example of the dlim option. It is most useful for making
   ## consistant multi-panel plots
   colors <- rep("black",times=length(ex))
   colors[ex > 10000] <- "red"
   colors[ex < 0] <- "blue"

   idiogram(ex,hu.chr,chr="1",col=colors,xlim=c(-3000,21000))
   idiogram(ex,hu.chr,chr="1",col=colors,dlim=c(-100,7500),xlim=c(-3000,21000))
   idiogram(ex,hu.chr,chr="1",col=colors,dlim=c(-100,7500),xlim=c(-3000,10000))

   ## Using the identify function
   ip <- idiogram(ex,hu.chr,chr="1",col=colors,pch=19)
   #identify(ip$x,ip$y,labels=ip$labels)
   
} else print("This example requires the hu6800 and golubEsets data packages.")

## The example data is BAC array CGH data from J. Fridlyand's
## aCGH package

data(idiogramExample)

idiogram(colo.eset@exprs[,1],ucsf.chr,chr="1")

idiogram(colo.eset@exprs,ucsf.chr,chr="1",method="image")

idiogram(colo.eset@exprs,ucsf.chr,chr="1",method="image",col=topo.colors(50),grid.lty=c(1,NA))

idiogram(colo.eset@exprs,ucsf.chr,chr="1",method="mat",type="l")

## for a consistant multi-panel plot it can be helpful to force the data
## range within each panel to a defined range using 'dlim'
## This is similar to calling the 'midiogram' function

op <- par(no.readonly=TRUE)
par(mai=par("mai")*c(0.1,0.5,0.5,0.5))
layout(rbind(c(1:8),c(0,9:14,0),c(15:22)))

for(i in c(1:22)) {
  idiogram(colo.eset@exprs,ucsf.chr,chr=i,method="i",dlim=c(-1,1),margin="i",relative=TRUE)
}

par(op)



