### Name: graphAM-class
### Title: Class "graphAM"
### Aliases: graphAM-class
###   addEdge,character,character,graphAM,missing-method
###   addNode,character,graphAM,missing-method
###   clearNode,character,graphAM-method coerce,graphAM,graphNEL-method
###   coerce,graphAM,matrix-method coerce,matrix,graphAM-method
###   edges,graphAM,missing-method edges,graphAM,character-method
###   initialize,graphAM-method inEdges,missing,graphAM-method
###   inEdges,character,graphAM-method inEdges,graphAM,missing-method
###   isAdjacent,graphAM,character,character-method
###   nodes<-,graphAM,character-method nodes,graphAM-method
###   numEdges,graphAM-method numNodes,graphAM-method
###   removeEdge,character,character,graphAM-method
###   removeNode,character,graphAM-method
### Keywords: graphs classes

### ** Examples

mat <- rbind(c(0, 0, 1, 1),
             c(0, 0, 1, 1),
             c(1, 1, 0, 1),
             c(1, 1, 1, 0))
rownames(mat) <- colnames(mat) <- letters[1:4]
g1 <- new("graphAM", adjMat=mat)
stopifnot(identical(mat, as(g1, "matrix")), validObject(g1))

## now with weights:
mat[1,3] <- mat[3,1] <- 10
gw <- new("graphAM", adjMat=mat, values=list(weight=1))

## consistency check:
stopifnot(identical(mat, as(gw, "matrix")),
          validObject(gw),
          identical(gw, as(as(gw, "graphNEL"), "graphAM")))



