### Name: write.htmltable
### Title: Write a data frame into an html table within a html page
### Aliases: write.htmltable
### Keywords: IO

### ** Examples

out = tempfile()

n  = 10
ex = data.frame(genename=paste("Gene", 1:n, sep=""),
                score   =signif(16*runif(n)),
                database=paste("http://super.data.base/?id", round(1e9*runif(n)), sep=""))

write.htmltable(ex, out, "Hi there", sortby="score")

cat("Now have a look at ", out, ".html\n", sep="")



