### Name: controlledSubsetting
### Title: Subsetting of Arrays
### Aliases: controlledSubsetting
### Keywords: utilities

### ** Examples

            a <- array(1:400, dim=c(2,3,5,6))
            r <- controlledSubsetting(a=a, ranges=list(1,2,3,2), drop=2)
            stopifnot(length(dim(r)) == 3 )
            stopifnot(r == a[1,2,3,2])
            r <- controlledSubsetting(a=a, ranges=list(2,1:2,2,2:3), drop=3)
            stopifnot( all(r[1,,,drop=TRUE] == a[2,1:2,2,2:3]) )
            r <- controlledSubsetting(a=a, ranges=list(1:2,1:2,2,3), drop=3)
            stopifnot( all(r[,,1,drop=TRUE] == a[1:2,1:2,2,3]) )
            r <- controlledSubsetting(a=a, ranges=list(1:2,1:2,2,3), drop=c(3,4))
            stopifnot( all(r == a[1:2,1:2,2,3]) )
            r <- controlledSubsetting(a=a, ranges=list(1:2,1:2,1:5,3), drop=c(4))
            stopifnot( all(r == a[1:2,1:2,1:5,3]) )
            r <- controlledSubsetting(a=a, ranges=list(NA,NA,1:5,3), drop=c(4))
            stopifnot( all(r == a[,,1:5,3]) )

        


