### Name: controlledApply
### Title: controlledApply
### Aliases: controlledApply
### Keywords: iteration

### ** Examples


a <- array(c(1:30),dim=c(3,2,5))
r <- controlledApply(a, 1, function(x){return(x[2,5])}, 1)
stopifnot( all(r == matrix(data=c(28:30))))

r <- controlledApply(a, 2, function(x){return(x[,])}, c(3,5))
stopifnot( all( a == aperm(r,c(2,1,3)) ) )

vec <- 1:10; dim(vec) <- c(10,1)
mat <- matrix(data=rep(1:10,4),nrow=10,ncol=4,byrow=FALSE)
r <- controlledApply(mat,1,function(y){return(mean(y))},1)
stopifnot(all(r==vec))

r <- controlledApply(mat, 1:2, function(x) return(x), 1)
stopifnot( all(r[,,1] == mat) )

r <- controlledApply(a, c(1,3) , function(x) return(x), dim(a)[2])
stopifnot( all(aperm(r[,,],c(1,3,2)) == a) )

r <- controlledApply(a, 1:2, function(x) return(x[2]), 1)
stopifnot( all(r[,,] == a[,,2]) )

r <- controlledApply(a, 1, function(x) return(x), c(dim(a)[2],dim(a)[3]))
stopifnot( all( r== a ) )

 ## Don't show: 

     nrOfDimensions <- as.integer(runif(n=1,min=1,max=7))
     allDimensions <- as.integer(runif(n=nrOfDimensions,min=4,max=8))
     arrayObject <- array(data=runif(prod(allDimensions)),dim=allDimensions)
     dimensionsLength <- as.integer(runif(n=1,min=1,max=nrOfDimensions))
     dimensions <- unique(as.integer(
                      runif(n=dimensionsLength,min=1,max=nrOfDimensions)))
     func <- mean
     result <- simpleApply(arrayObject=arrayObject,
                           dimensions=dimensions,
                           func=func,
                           funcResultDimensionality = 1)

     result2 <- simpleApply(arrayObject=arrayObject,
                            dimensions=dimensions,
                            func=func,
                            funcResultDimensionality = 1)
     stopifnot( identical(result, result2))
    

r <- controlledApply(matrix(c(1, 2)), 1, sum, 1)
stopifnot( all(r == matrix(c(1,2))) )

a <- array(c(1:30),dim=c(3,2,5))
r <- controlledApply(a, 1, function(x){return(x[1])}, 1)
stopifnot( all(r == matrix(data=c(1:3))))

r <- controlledApply(a, 1, function(x){return(x[1,3])}, 1)
stopifnot( all(r == matrix(data=c(13:15))))

r <- controlledApply(a, 1, function(x){return(x[,])}, c(2,5))
stopifnot( all( a == r))

r <- controlledApply(a, 3, function(x){return(x[,])}, c(3,2))
stopifnot( all( a == aperm(r,c(2,3,1)) ) )

r2 <- controlledApply(a, 1, function(x){ return(as.vector(x))}, 10)

r <- controlledApply(a, 1:3, function(x) return(x), 1)
stopifnot( all(r[,,,1] == a) )

r <- controlledApply(a, 1:2, function(x) return(x), dim(a)[3])
stopifnot( all(r[,,] == a) )

r <- controlledApply(a, 1:2, function(x) return(x[1]), 1)

r <- controlledApply(a, 1:2, function(x) return(x[1]), 1)
stopifnot( all(r[,,] == a[,,1]) )

       ## End Don't show

 


